/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH128_canonical_t")
public class XXH128Canonical
extends Struct<XXH128Canonical>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    protected XXH128Canonical(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XXH128Canonical create(long address, @Nullable ByteBuffer container) {
        return new XXH128Canonical(address, container);
    }

    public XXH128Canonical(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH128Canonical.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[16]")
    public ByteBuffer digest() {
        return XXH128Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH128Canonical.ndigest(this.address(), index);
    }

    public static XXH128Canonical malloc() {
        return new XXH128Canonical(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XXH128Canonical calloc() {
        return new XXH128Canonical(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XXH128Canonical create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XXH128Canonical(MemoryUtil.memAddress(container), container);
    }

    public static XXH128Canonical create(long address) {
        return new XXH128Canonical(address, null);
    }

    public static @Nullable XXH128Canonical createSafe(long address) {
        return address == 0L ? null : new XXH128Canonical(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XXH128Canonical.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH128Canonical.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static XXH128Canonical mallocStack() {
        return XXH128Canonical.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Canonical callocStack() {
        return XXH128Canonical.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Canonical mallocStack(MemoryStack stack) {
        return XXH128Canonical.malloc(stack);
    }

    @Deprecated
    public static XXH128Canonical callocStack(MemoryStack stack) {
        return XXH128Canonical.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH128Canonical.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH128Canonical.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH128Canonical.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH128Canonical.calloc(capacity, stack);
    }

    public static XXH128Canonical malloc(MemoryStack stack) {
        return new XXH128Canonical(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XXH128Canonical calloc(MemoryStack stack) {
        return new XXH128Canonical(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DIGEST, 16);
    }

    public static byte ndigest(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DIGEST + Checks.check(index, 16) * 1L);
    }

    static {
        Struct.Layout layout = XXH128Canonical.__struct(XXH128Canonical.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH128Canonical, Buffer>
    implements NativeResource {
        private static final XXH128Canonical ELEMENT_FACTORY = XXH128Canonical.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XXH128Canonical getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[16]")
        public ByteBuffer digest() {
            return XXH128Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH128Canonical.ndigest(this.address(), index);
        }
    }
}

