/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH32_canonical_t")
public class XXH32Canonical
extends Struct<XXH32Canonical>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    protected XXH32Canonical(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XXH32Canonical create(long address, @Nullable ByteBuffer container) {
        return new XXH32Canonical(address, container);
    }

    public XXH32Canonical(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH32Canonical.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[4]")
    public ByteBuffer digest() {
        return XXH32Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH32Canonical.ndigest(this.address(), index);
    }

    public static XXH32Canonical malloc() {
        return new XXH32Canonical(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XXH32Canonical calloc() {
        return new XXH32Canonical(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XXH32Canonical create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XXH32Canonical(MemoryUtil.memAddress(container), container);
    }

    public static XXH32Canonical create(long address) {
        return new XXH32Canonical(address, null);
    }

    public static @Nullable XXH32Canonical createSafe(long address) {
        return address == 0L ? null : new XXH32Canonical(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XXH32Canonical.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH32Canonical.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static XXH32Canonical mallocStack() {
        return XXH32Canonical.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32Canonical callocStack() {
        return XXH32Canonical.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32Canonical mallocStack(MemoryStack stack) {
        return XXH32Canonical.malloc(stack);
    }

    @Deprecated
    public static XXH32Canonical callocStack(MemoryStack stack) {
        return XXH32Canonical.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH32Canonical.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH32Canonical.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.calloc(capacity, stack);
    }

    public static XXH32Canonical malloc(MemoryStack stack) {
        return new XXH32Canonical(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XXH32Canonical calloc(MemoryStack stack) {
        return new XXH32Canonical(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DIGEST, 4);
    }

    public static byte ndigest(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DIGEST + Checks.check(index, 4) * 1L);
    }

    static {
        Struct.Layout layout = XXH32Canonical.__struct(XXH32Canonical.__array(1, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH32Canonical, Buffer>
    implements NativeResource {
        private static final XXH32Canonical ELEMENT_FACTORY = XXH32Canonical.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XXH32Canonical getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[4]")
        public ByteBuffer digest() {
            return XXH32Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH32Canonical.ndigest(this.address(), index);
        }
    }
}

