/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH32_state_t")
public class XXH32State
extends Struct<XXH32State>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN_32;
    public static final int LARGE_LEN;
    public static final int ACC;
    public static final int BUFFER;
    public static final int BUFFEREDSIZE;
    public static final int RESERVED;

    protected XXH32State(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XXH32State create(long address, @Nullable ByteBuffer container) {
        return new XXH32State(address, container);
    }

    public XXH32State(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH32State.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH32_hash_t")
    public int total_len_32() {
        return XXH32State.ntotal_len_32(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int large_len() {
        return XXH32State.nlarge_len(this.address());
    }

    @NativeType(value="XXH32_hash_t[4]")
    public IntBuffer acc() {
        return XXH32State.nacc(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int acc(int index) {
        return XXH32State.nacc(this.address(), index);
    }

    @NativeType(value="unsigned char[16]")
    public ByteBuffer buffer() {
        return XXH32State.nbuffer(this.address());
    }

    @NativeType(value="unsigned char")
    public byte buffer(int index) {
        return XXH32State.nbuffer(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int bufferedSize() {
        return XXH32State.nbufferedSize(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int reserved() {
        return XXH32State.nreserved(this.address());
    }

    public static XXH32State malloc() {
        return new XXH32State(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XXH32State calloc() {
        return new XXH32State(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XXH32State create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XXH32State(MemoryUtil.memAddress(container), container);
    }

    public static XXH32State create(long address) {
        return new XXH32State(address, null);
    }

    public static @Nullable XXH32State createSafe(long address) {
        return address == 0L ? null : new XXH32State(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XXH32State.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH32State.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static XXH32State mallocStack() {
        return XXH32State.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32State callocStack() {
        return XXH32State.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32State mallocStack(MemoryStack stack) {
        return XXH32State.malloc(stack);
    }

    @Deprecated
    public static XXH32State callocStack(MemoryStack stack) {
        return XXH32State.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH32State.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH32State.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH32State.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH32State.calloc(capacity, stack);
    }

    public static XXH32State malloc(MemoryStack stack) {
        return new XXH32State(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XXH32State calloc(MemoryStack stack) {
        return new XXH32State(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntotal_len_32(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOTAL_LEN_32);
    }

    public static int nlarge_len(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LARGE_LEN);
    }

    public static IntBuffer nacc(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)ACC, 4);
    }

    public static int nacc(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)ACC + Checks.check(index, 4) * 4L);
    }

    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)BUFFER, 16);
    }

    public static byte nbuffer(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)BUFFER + Checks.check(index, 16) * 1L);
    }

    public static int nbufferedSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFEREDSIZE);
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED);
    }

    static {
        Struct.Layout layout = XXH32State.__struct(XXH32State.__member(4), XXH32State.__member(4), XXH32State.__array(4, 4), XXH32State.__array(1, 16), XXH32State.__member(4), XXH32State.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN_32 = layout.offsetof(0);
        LARGE_LEN = layout.offsetof(1);
        ACC = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        BUFFEREDSIZE = layout.offsetof(4);
        RESERVED = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XXH32State, Buffer>
    implements NativeResource {
        private static final XXH32State ELEMENT_FACTORY = XXH32State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XXH32State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH32_hash_t")
        public int total_len_32() {
            return XXH32State.ntotal_len_32(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int large_len() {
            return XXH32State.nlarge_len(this.address());
        }

        @NativeType(value="XXH32_hash_t[4]")
        public IntBuffer acc() {
            return XXH32State.nacc(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int acc(int index) {
            return XXH32State.nacc(this.address(), index);
        }

        @NativeType(value="unsigned char[16]")
        public ByteBuffer buffer() {
            return XXH32State.nbuffer(this.address());
        }

        @NativeType(value="unsigned char")
        public byte buffer(int index) {
            return XXH32State.nbuffer(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int bufferedSize() {
            return XXH32State.nbufferedSize(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int reserved() {
            return XXH32State.nreserved(this.address());
        }
    }
}

