/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_state_t")
public class XXH64State
extends Struct<XXH64State>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN;
    public static final int ACC;
    public static final int BUFFER;
    public static final int BUFFEREDSIZE;
    public static final int RESERVED32;
    public static final int RESERVED64;

    protected XXH64State(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XXH64State create(long address, @Nullable ByteBuffer container) {
        return new XXH64State(address, container);
    }

    public XXH64State(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH64State.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH64_hash_t")
    public long total_len() {
        return XXH64State.ntotal_len(this.address());
    }

    @NativeType(value="XXH64_hash_t[4]")
    public LongBuffer acc() {
        return XXH64State.nacc(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long acc(int index) {
        return XXH64State.nacc(this.address(), index);
    }

    @NativeType(value="unsigned char[32]")
    public ByteBuffer buffer() {
        return XXH64State.nbuffer(this.address());
    }

    @NativeType(value="unsigned char")
    public byte buffer(int index) {
        return XXH64State.nbuffer(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int bufferedSize() {
        return XXH64State.nbufferedSize(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int reserved32() {
        return XXH64State.nreserved32(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long reserved64() {
        return XXH64State.nreserved64(this.address());
    }

    public static XXH64State malloc() {
        return new XXH64State(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XXH64State calloc() {
        return new XXH64State(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XXH64State create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XXH64State(MemoryUtil.memAddress(container), container);
    }

    public static XXH64State create(long address) {
        return new XXH64State(address, null);
    }

    public static @Nullable XXH64State createSafe(long address) {
        return address == 0L ? null : new XXH64State(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XXH64State.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH64State.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static XXH64State mallocStack() {
        return XXH64State.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64State callocStack() {
        return XXH64State.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64State mallocStack(MemoryStack stack) {
        return XXH64State.malloc(stack);
    }

    @Deprecated
    public static XXH64State callocStack(MemoryStack stack) {
        return XXH64State.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH64State.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH64State.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64State.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64State.calloc(capacity, stack);
    }

    public static XXH64State malloc(MemoryStack stack) {
        return new XXH64State(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XXH64State calloc(MemoryStack stack) {
        return new XXH64State(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntotal_len(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TOTAL_LEN);
    }

    public static LongBuffer nacc(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)ACC, 4);
    }

    public static long nacc(long struct, int index) {
        return MemoryUtil.memGetLong(struct + (long)ACC + Checks.check(index, 4) * 8L);
    }

    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)BUFFER, 32);
    }

    public static byte nbuffer(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)BUFFER + Checks.check(index, 32) * 1L);
    }

    public static int nbufferedSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUFFEREDSIZE);
    }

    public static int nreserved32(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED32);
    }

    public static long nreserved64(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RESERVED64);
    }

    static {
        Struct.Layout layout = XXH64State.__struct(XXH64State.__member(8), XXH64State.__array(8, 4), XXH64State.__array(1, 32), XXH64State.__member(4), XXH64State.__member(4), XXH64State.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN = layout.offsetof(0);
        ACC = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
        BUFFEREDSIZE = layout.offsetof(3);
        RESERVED32 = layout.offsetof(4);
        RESERVED64 = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XXH64State, Buffer>
    implements NativeResource {
        private static final XXH64State ELEMENT_FACTORY = XXH64State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XXH64State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH64_hash_t")
        public long total_len() {
            return XXH64State.ntotal_len(this.address());
        }

        @NativeType(value="XXH64_hash_t[4]")
        public LongBuffer acc() {
            return XXH64State.nacc(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long acc(int index) {
            return XXH64State.nacc(this.address(), index);
        }

        @NativeType(value="unsigned char[32]")
        public ByteBuffer buffer() {
            return XXH64State.nbuffer(this.address());
        }

        @NativeType(value="unsigned char")
        public byte buffer(int index) {
            return XXH64State.nbuffer(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int bufferedSize() {
            return XXH64State.nbufferedSize(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int reserved32() {
            return XXH64State.nreserved32(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long reserved64() {
            return XXH64State.nreserved64(this.address());
        }
    }
}

