/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.zstd.LibZstd;
import org.lwjgl.util.zstd.ZDICTCoverParams;
import org.lwjgl.util.zstd.ZDICTFastCoverParams;
import org.lwjgl.util.zstd.ZDICTParams;

public class Zdict {
    public static final int ZDICT_CONTENTSIZE_MIN = 128;
    public static final int ZDICT_DICTSIZE_MIN = 256;

    protected Zdict() {
        throw new UnsupportedOperationException();
    }

    public static native long nZDICT_trainFromBuffer(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="size_t")
    public static long ZDICT_trainFromBuffer(@NativeType(value="void *") ByteBuffer dictBuffer, @NativeType(value="void const *") ByteBuffer samplesBuffer, @NativeType(value="size_t const *") PointerBuffer samplesSizes) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)samplesBuffer, Zdict.getSamplesBufferSize(samplesSizes));
        }
        return Zdict.nZDICT_trainFromBuffer(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining(), MemoryUtil.memAddress(samplesBuffer), MemoryUtil.memAddress(samplesSizes), samplesSizes.remaining());
    }

    public static native int nZDICT_getDictID(long var0, long var2);

    @NativeType(value="unsigned int")
    public static int ZDICT_getDictID(@NativeType(value="void const *") ByteBuffer dictBuffer) {
        return Zdict.nZDICT_getDictID(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining());
    }

    public static native int nZDICT_isError(long var0);

    @NativeType(value="unsigned int")
    public static boolean ZDICT_isError(@NativeType(value="size_t") long errorCode) {
        return Zdict.nZDICT_isError(errorCode) != 0;
    }

    public static native long nZDICT_getErrorName(long var0);

    @NativeType(value="char const *")
    public static @Nullable String ZDICT_getErrorName(@NativeType(value="size_t") long errorCode) {
        long __result = Zdict.nZDICT_getErrorName(errorCode);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static native long nZDICT_trainFromBuffer_cover(long var0, long var2, long var4, long var6, int var8, long var9);

    @NativeType(value="size_t")
    public static long ZDICT_trainFromBuffer_cover(@NativeType(value="void *") ByteBuffer dictBuffer, @NativeType(value="void const *") ByteBuffer samplesBuffer, @NativeType(value="size_t const *") PointerBuffer samplesSizes, @NativeType(value="ZDICT_cover_params_t") ZDICTCoverParams parameters) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)samplesBuffer, Zdict.getSamplesBufferSize(samplesSizes));
        }
        return Zdict.nZDICT_trainFromBuffer_cover(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining(), MemoryUtil.memAddress(samplesBuffer), MemoryUtil.memAddress(samplesSizes), samplesSizes.remaining(), parameters.address());
    }

    public static native long nZDICT_optimizeTrainFromBuffer_cover(long var0, long var2, long var4, long var6, int var8, long var9);

    @NativeType(value="size_t")
    public static long ZDICT_optimizeTrainFromBuffer_cover(@NativeType(value="void *") ByteBuffer dictBuffer, @NativeType(value="void const *") ByteBuffer samplesBuffer, @NativeType(value="size_t const *") PointerBuffer samplesSizes, @NativeType(value="ZDICT_cover_params_t *") ZDICTCoverParams parameters) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)samplesBuffer, Zdict.getSamplesBufferSize(samplesSizes));
        }
        return Zdict.nZDICT_optimizeTrainFromBuffer_cover(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining(), MemoryUtil.memAddress(samplesBuffer), MemoryUtil.memAddress(samplesSizes), samplesSizes.remaining(), parameters.address());
    }

    public static native long nZDICT_trainFromBuffer_fastCover(long var0, long var2, long var4, long var6, int var8, long var9);

    @NativeType(value="size_t")
    public static long ZDICT_trainFromBuffer_fastCover(@NativeType(value="void *") ByteBuffer dictBuffer, @NativeType(value="void const *") ByteBuffer samplesBuffer, @NativeType(value="size_t const *") PointerBuffer samplesSizes, @NativeType(value="ZDICT_fastCover_params_t") ZDICTFastCoverParams parameters) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)samplesBuffer, Zdict.getSamplesBufferSize(samplesSizes));
        }
        return Zdict.nZDICT_trainFromBuffer_fastCover(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining(), MemoryUtil.memAddress(samplesBuffer), MemoryUtil.memAddress(samplesSizes), samplesSizes.remaining(), parameters.address());
    }

    public static native long nZDICT_optimizeTrainFromBuffer_fastCover(long var0, long var2, long var4, long var6, int var8, long var9);

    @NativeType(value="size_t")
    public static long ZDICT_optimizeTrainFromBuffer_fastCover(@NativeType(value="void *") ByteBuffer dictBuffer, @NativeType(value="void const *") ByteBuffer samplesBuffer, @NativeType(value="size_t const *") PointerBuffer samplesSizes, @NativeType(value="ZDICT_fastCover_params_t *") ZDICTFastCoverParams parameters) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)samplesBuffer, Zdict.getSamplesBufferSize(samplesSizes));
        }
        return Zdict.nZDICT_optimizeTrainFromBuffer_fastCover(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining(), MemoryUtil.memAddress(samplesBuffer), MemoryUtil.memAddress(samplesSizes), samplesSizes.remaining(), parameters.address());
    }

    public static native long nZDICT_finalizeDictionary(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13);

    @NativeType(value="size_t")
    public static long ZDICT_finalizeDictionary(@NativeType(value="void *") ByteBuffer dictBuffer, @NativeType(value="void const *") ByteBuffer dictContent, @NativeType(value="void const *") ByteBuffer samplesBuffer, @NativeType(value="size_t const *") PointerBuffer samplesSizes, @NativeType(value="ZDICT_params_t") ZDICTParams parameters) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)samplesBuffer, Zdict.getSamplesBufferSize(samplesSizes));
        }
        return Zdict.nZDICT_finalizeDictionary(MemoryUtil.memAddress(dictBuffer), dictBuffer.remaining(), MemoryUtil.memAddress(dictContent), dictContent.remaining(), MemoryUtil.memAddress(samplesBuffer), MemoryUtil.memAddress(samplesSizes), samplesSizes.remaining(), parameters.address());
    }

    private static long getSamplesBufferSize(PointerBuffer samplesSizes) {
        long bytes = 0L;
        for (int i = 0; i < samplesSizes.remaining(); ++i) {
            bytes += samplesSizes.get(i);
        }
        return bytes;
    }

    static {
        LibZstd.initialize();
    }
}

