/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCopyImageToImageInfo;
import org.lwjgl.vulkan.VkCopyImageToMemoryInfo;
import org.lwjgl.vulkan.VkCopyMemoryToImageInfo;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkHostImageLayoutTransitionInfo;
import org.lwjgl.vulkan.VkImageSubresource2;
import org.lwjgl.vulkan.VkSubresourceLayout2;

public class EXTHostImageCopy {
    public static final int VK_EXT_HOST_IMAGE_COPY_SPEC_VERSION = 1;
    public static final String VK_EXT_HOST_IMAGE_COPY_EXTENSION_NAME = "VK_EXT_host_image_copy";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES_EXT = 1000270000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES_EXT = 1000270001;
    public static final int VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY_EXT = 1000270002;
    public static final int VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY_EXT = 1000270003;
    public static final int VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_EXT = 1000270004;
    public static final int VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_EXT = 1000270005;
    public static final int VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO_EXT = 1000270006;
    public static final int VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO_EXT = 1000270007;
    public static final int VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE_EXT = 1000270008;
    public static final int VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY_EXT = 1000270009;
    public static final int VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT = 0x400000;
    public static final long VK_FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT_EXT = 0x400000000000L;
    public static final int VK_HOST_IMAGE_COPY_MEMCPY_EXT = 1;

    protected EXTHostImageCopy() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCopyMemoryToImageEXT(VkDevice device, long pCopyMemoryToImageInfo) {
        long __functionAddress = device.getCapabilities().vkCopyMemoryToImageEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkCopyMemoryToImageInfo.validate(pCopyMemoryToImageInfo);
        }
        return JNI.callPPI(device.address(), pCopyMemoryToImageInfo, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCopyMemoryToImageEXT(VkDevice device, @NativeType(value="VkCopyMemoryToImageInfo const *") VkCopyMemoryToImageInfo pCopyMemoryToImageInfo) {
        return EXTHostImageCopy.nvkCopyMemoryToImageEXT(device, pCopyMemoryToImageInfo.address());
    }

    public static int nvkCopyImageToMemoryEXT(VkDevice device, long pCopyImageToMemoryInfo) {
        long __functionAddress = device.getCapabilities().vkCopyImageToMemoryEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkCopyImageToMemoryInfo.validate(pCopyImageToMemoryInfo);
        }
        return JNI.callPPI(device.address(), pCopyImageToMemoryInfo, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCopyImageToMemoryEXT(VkDevice device, @NativeType(value="VkCopyImageToMemoryInfo const *") VkCopyImageToMemoryInfo pCopyImageToMemoryInfo) {
        return EXTHostImageCopy.nvkCopyImageToMemoryEXT(device, pCopyImageToMemoryInfo.address());
    }

    public static int nvkCopyImageToImageEXT(VkDevice device, long pCopyImageToImageInfo) {
        long __functionAddress = device.getCapabilities().vkCopyImageToImageEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkCopyImageToImageInfo.validate(pCopyImageToImageInfo);
        }
        return JNI.callPPI(device.address(), pCopyImageToImageInfo, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCopyImageToImageEXT(VkDevice device, @NativeType(value="VkCopyImageToImageInfo const *") VkCopyImageToImageInfo pCopyImageToImageInfo) {
        return EXTHostImageCopy.nvkCopyImageToImageEXT(device, pCopyImageToImageInfo.address());
    }

    public static int nvkTransitionImageLayoutEXT(VkDevice device, int transitionCount, long pTransitions) {
        long __functionAddress = device.getCapabilities().vkTransitionImageLayoutEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(device.address(), transitionCount, pTransitions, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkTransitionImageLayoutEXT(VkDevice device, @NativeType(value="VkHostImageLayoutTransitionInfo const *") VkHostImageLayoutTransitionInfo.Buffer pTransitions) {
        return EXTHostImageCopy.nvkTransitionImageLayoutEXT(device, pTransitions.remaining(), pTransitions.address());
    }

    public static void nvkGetImageSubresourceLayout2EXT(VkDevice device, long image, long pSubresource, long pLayout) {
        long __functionAddress = device.getCapabilities().vkGetImageSubresourceLayout2EXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJPPV(device.address(), image, pSubresource, pLayout, __functionAddress);
    }

    public static void vkGetImageSubresourceLayout2EXT(VkDevice device, @NativeType(value="VkImage") long image, @NativeType(value="VkImageSubresource2 const *") VkImageSubresource2 pSubresource, @NativeType(value="VkSubresourceLayout2 *") VkSubresourceLayout2 pLayout) {
        EXTHostImageCopy.nvkGetImageSubresourceLayout2EXT(device, image, pSubresource.address(), pLayout.address());
    }
}

