/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkRefreshCycleDurationGOOGLE;

public class GOOGLEDisplayTiming {
    public static final int VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION = 1;
    public static final String VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME = "VK_GOOGLE_display_timing";
    public static final int VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE = 1000092000;

    protected GOOGLEDisplayTiming() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetRefreshCycleDurationGOOGLE(VkDevice device, long swapchain, long pDisplayTimingProperties) {
        long __functionAddress = device.getCapabilities().vkGetRefreshCycleDurationGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(device.address(), swapchain, pDisplayTimingProperties, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetRefreshCycleDurationGOOGLE(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="VkRefreshCycleDurationGOOGLE *") VkRefreshCycleDurationGOOGLE pDisplayTimingProperties) {
        return GOOGLEDisplayTiming.nvkGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties.address());
    }

    public static int nvkGetPastPresentationTimingGOOGLE(VkDevice device, long swapchain, long pPresentationTimingCount, long pPresentationTimings) {
        long __functionAddress = device.getCapabilities().vkGetPastPresentationTimingGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(device.address(), swapchain, pPresentationTimingCount, pPresentationTimings, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPastPresentationTimingGOOGLE(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="uint32_t *") IntBuffer pPresentationTimingCount, @NativeType(value="VkPastPresentationTimingGOOGLE *")  @Nullable VkPastPresentationTimingGOOGLE.Buffer pPresentationTimings) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPresentationTimingCount, 1);
            Checks.checkSafe(pPresentationTimings, pPresentationTimingCount.get(pPresentationTimingCount.position()));
        }
        return GOOGLEDisplayTiming.nvkGetPastPresentationTimingGOOGLE(device, swapchain, MemoryUtil.memAddress(pPresentationTimingCount), MemoryUtil.memAddressSafe(pPresentationTimings));
    }

    @NativeType(value="VkResult")
    public static int vkGetPastPresentationTimingGOOGLE(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapchain, @NativeType(value="uint32_t *") int[] pPresentationTimingCount, @NativeType(value="VkPastPresentationTimingGOOGLE *")  @Nullable VkPastPresentationTimingGOOGLE.Buffer pPresentationTimings) {
        long __functionAddress = device.getCapabilities().vkGetPastPresentationTimingGOOGLE;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pPresentationTimingCount, 1);
            Checks.checkSafe(pPresentationTimings, pPresentationTimingCount[0]);
        }
        return JNI.callPJPPI(device.address(), swapchain, pPresentationTimingCount, MemoryUtil.memAddressSafe(pPresentationTimings), __functionAddress);
    }
}

