/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAccelerationStructureBuildRangeInfoKHR
extends Struct<VkAccelerationStructureBuildRangeInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PRIMITIVECOUNT;
    public static final int PRIMITIVEOFFSET;
    public static final int FIRSTVERTEX;
    public static final int TRANSFORMOFFSET;

    protected VkAccelerationStructureBuildRangeInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAccelerationStructureBuildRangeInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureBuildRangeInfoKHR(address, container);
    }

    public VkAccelerationStructureBuildRangeInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureBuildRangeInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int primitiveCount() {
        return VkAccelerationStructureBuildRangeInfoKHR.nprimitiveCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int primitiveOffset() {
        return VkAccelerationStructureBuildRangeInfoKHR.nprimitiveOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstVertex() {
        return VkAccelerationStructureBuildRangeInfoKHR.nfirstVertex(this.address());
    }

    @NativeType(value="uint32_t")
    public int transformOffset() {
        return VkAccelerationStructureBuildRangeInfoKHR.ntransformOffset(this.address());
    }

    public VkAccelerationStructureBuildRangeInfoKHR primitiveCount(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureBuildRangeInfoKHR.nprimitiveCount(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildRangeInfoKHR primitiveOffset(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureBuildRangeInfoKHR.nprimitiveOffset(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildRangeInfoKHR firstVertex(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureBuildRangeInfoKHR.nfirstVertex(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildRangeInfoKHR transformOffset(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureBuildRangeInfoKHR.ntransformOffset(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildRangeInfoKHR set(int primitiveCount, int primitiveOffset, int firstVertex, int transformOffset) {
        this.primitiveCount(primitiveCount);
        this.primitiveOffset(primitiveOffset);
        this.firstVertex(firstVertex);
        this.transformOffset(transformOffset);
        return this;
    }

    public VkAccelerationStructureBuildRangeInfoKHR set(VkAccelerationStructureBuildRangeInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureBuildRangeInfoKHR malloc() {
        return new VkAccelerationStructureBuildRangeInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAccelerationStructureBuildRangeInfoKHR calloc() {
        return new VkAccelerationStructureBuildRangeInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAccelerationStructureBuildRangeInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAccelerationStructureBuildRangeInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureBuildRangeInfoKHR create(long address) {
        return new VkAccelerationStructureBuildRangeInfoKHR(address, null);
    }

    public static @Nullable VkAccelerationStructureBuildRangeInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureBuildRangeInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAccelerationStructureBuildRangeInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureBuildRangeInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureBuildRangeInfoKHR malloc(MemoryStack stack) {
        return new VkAccelerationStructureBuildRangeInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureBuildRangeInfoKHR calloc(MemoryStack stack) {
        return new VkAccelerationStructureBuildRangeInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nprimitiveCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRIMITIVECOUNT);
    }

    public static int nprimitiveOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRIMITIVEOFFSET);
    }

    public static int nfirstVertex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTVERTEX);
    }

    public static int ntransformOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRANSFORMOFFSET);
    }

    public static void nprimitiveCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRIMITIVECOUNT, value);
    }

    public static void nprimitiveOffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRIMITIVEOFFSET, value);
    }

    public static void nfirstVertex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTVERTEX, value);
    }

    public static void ntransformOffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TRANSFORMOFFSET, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureBuildRangeInfoKHR.__struct(VkAccelerationStructureBuildRangeInfoKHR.__member(4), VkAccelerationStructureBuildRangeInfoKHR.__member(4), VkAccelerationStructureBuildRangeInfoKHR.__member(4), VkAccelerationStructureBuildRangeInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PRIMITIVECOUNT = layout.offsetof(0);
        PRIMITIVEOFFSET = layout.offsetof(1);
        FIRSTVERTEX = layout.offsetof(2);
        TRANSFORMOFFSET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureBuildRangeInfoKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureBuildRangeInfoKHR ELEMENT_FACTORY = VkAccelerationStructureBuildRangeInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkAccelerationStructureBuildRangeInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int primitiveCount() {
            return VkAccelerationStructureBuildRangeInfoKHR.nprimitiveCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int primitiveOffset() {
            return VkAccelerationStructureBuildRangeInfoKHR.nprimitiveOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstVertex() {
            return VkAccelerationStructureBuildRangeInfoKHR.nfirstVertex(this.address());
        }

        @NativeType(value="uint32_t")
        public int transformOffset() {
            return VkAccelerationStructureBuildRangeInfoKHR.ntransformOffset(this.address());
        }

        public Buffer primitiveCount(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureBuildRangeInfoKHR.nprimitiveCount(this.address(), value);
            return this;
        }

        public Buffer primitiveOffset(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureBuildRangeInfoKHR.nprimitiveOffset(this.address(), value);
            return this;
        }

        public Buffer firstVertex(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureBuildRangeInfoKHR.nfirstVertex(this.address(), value);
            return this;
        }

        public Buffer transformOffset(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureBuildRangeInfoKHR.ntransformOffset(this.address(), value);
            return this;
        }
    }
}

