/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureMotionInfoNV;
import org.lwjgl.vulkan.VkOpaqueCaptureDescriptorDataCreateInfoEXT;

public class VkAccelerationStructureCreateInfoKHR
extends Struct<VkAccelerationStructureCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int CREATEFLAGS;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int TYPE;
    public static final int DEVICEADDRESS;

    protected VkAccelerationStructureCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAccelerationStructureCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureCreateInfoKHR(address, container);
    }

    public VkAccelerationStructureCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureCreateFlagsKHR")
    public int createFlags() {
        return VkAccelerationStructureCreateInfoKHR.ncreateFlags(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkAccelerationStructureCreateInfoKHR.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkAccelerationStructureCreateInfoKHR.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkAccelerationStructureCreateInfoKHR.nsize(this.address());
    }

    @NativeType(value="VkAccelerationStructureTypeKHR")
    public int type() {
        return VkAccelerationStructureCreateInfoKHR.ntype(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkAccelerationStructureCreateInfoKHR.ndeviceAddress(this.address());
    }

    public VkAccelerationStructureCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR sType$Default() {
        return this.sType(1000150017);
    }

    public VkAccelerationStructureCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR pNext(VkAccelerationStructureMotionInfoNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkAccelerationStructureCreateInfoKHR pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkAccelerationStructureCreateInfoKHR createFlags(@NativeType(value="VkAccelerationStructureCreateFlagsKHR") int value) {
        VkAccelerationStructureCreateInfoKHR.ncreateFlags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkAccelerationStructureCreateInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR offset(@NativeType(value="VkDeviceSize") long value) {
        VkAccelerationStructureCreateInfoKHR.noffset(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR size(@NativeType(value="VkDeviceSize") long value) {
        VkAccelerationStructureCreateInfoKHR.nsize(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
        VkAccelerationStructureCreateInfoKHR.ntype(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkAccelerationStructureCreateInfoKHR.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR set(int sType, long pNext, int createFlags, long buffer, long offset, long size, int type, long deviceAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.createFlags(createFlags);
        this.buffer(buffer);
        this.offset(offset);
        this.size(size);
        this.type(type);
        this.deviceAddress(deviceAddress);
        return this;
    }

    public VkAccelerationStructureCreateInfoKHR set(VkAccelerationStructureCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureCreateInfoKHR malloc() {
        return new VkAccelerationStructureCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoKHR calloc() {
        return new VkAccelerationStructureCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAccelerationStructureCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureCreateInfoKHR create(long address) {
        return new VkAccelerationStructureCreateInfoKHR(address, null);
    }

    public static @Nullable VkAccelerationStructureCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAccelerationStructureCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureCreateInfoKHR malloc(MemoryStack stack) {
        return new VkAccelerationStructureCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureCreateInfoKHR calloc(MemoryStack stack) {
        return new VkAccelerationStructureCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncreateFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CREATEFLAGS);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long ndeviceAddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DEVICEADDRESS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncreateFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CREATEFLAGS, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void ndeviceAddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DEVICEADDRESS, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureCreateInfoKHR.__struct(VkAccelerationStructureCreateInfoKHR.__member(4), VkAccelerationStructureCreateInfoKHR.__member(POINTER_SIZE), VkAccelerationStructureCreateInfoKHR.__member(4), VkAccelerationStructureCreateInfoKHR.__member(8), VkAccelerationStructureCreateInfoKHR.__member(8), VkAccelerationStructureCreateInfoKHR.__member(8), VkAccelerationStructureCreateInfoKHR.__member(4), VkAccelerationStructureCreateInfoKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        SIZE = layout.offsetof(5);
        TYPE = layout.offsetof(6);
        DEVICEADDRESS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureCreateInfoKHR ELEMENT_FACTORY = VkAccelerationStructureCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkAccelerationStructureCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureCreateFlagsKHR")
        public int createFlags() {
            return VkAccelerationStructureCreateInfoKHR.ncreateFlags(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkAccelerationStructureCreateInfoKHR.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkAccelerationStructureCreateInfoKHR.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkAccelerationStructureCreateInfoKHR.nsize(this.address());
        }

        @NativeType(value="VkAccelerationStructureTypeKHR")
        public int type() {
            return VkAccelerationStructureCreateInfoKHR.ntype(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkAccelerationStructureCreateInfoKHR.ndeviceAddress(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150017);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkAccelerationStructureMotionInfoNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer createFlags(@NativeType(value="VkAccelerationStructureCreateFlagsKHR") int value) {
            VkAccelerationStructureCreateInfoKHR.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkAccelerationStructureCreateInfoKHR.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkAccelerationStructureCreateInfoKHR.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkAccelerationStructureCreateInfoKHR.nsize(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
            VkAccelerationStructureCreateInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkAccelerationStructureCreateInfoKHR.ndeviceAddress(this.address(), value);
            return this;
        }
    }
}

