/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAccelerationStructureDeviceAddressInfoKHR
extends Struct<VkAccelerationStructureDeviceAddressInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ACCELERATIONSTRUCTURE;

    protected VkAccelerationStructureDeviceAddressInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAccelerationStructureDeviceAddressInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureDeviceAddressInfoKHR(address, container);
    }

    public VkAccelerationStructureDeviceAddressInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureDeviceAddressInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureDeviceAddressInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureDeviceAddressInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long accelerationStructure() {
        return VkAccelerationStructureDeviceAddressInfoKHR.naccelerationStructure(this.address());
    }

    public VkAccelerationStructureDeviceAddressInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureDeviceAddressInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureDeviceAddressInfoKHR sType$Default() {
        return this.sType(1000150002);
    }

    public VkAccelerationStructureDeviceAddressInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureDeviceAddressInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureDeviceAddressInfoKHR accelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkAccelerationStructureDeviceAddressInfoKHR.naccelerationStructure(this.address(), value);
        return this;
    }

    public VkAccelerationStructureDeviceAddressInfoKHR set(int sType, long pNext, long accelerationStructure) {
        this.sType(sType);
        this.pNext(pNext);
        this.accelerationStructure(accelerationStructure);
        return this;
    }

    public VkAccelerationStructureDeviceAddressInfoKHR set(VkAccelerationStructureDeviceAddressInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureDeviceAddressInfoKHR malloc() {
        return new VkAccelerationStructureDeviceAddressInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAccelerationStructureDeviceAddressInfoKHR calloc() {
        return new VkAccelerationStructureDeviceAddressInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAccelerationStructureDeviceAddressInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAccelerationStructureDeviceAddressInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureDeviceAddressInfoKHR create(long address) {
        return new VkAccelerationStructureDeviceAddressInfoKHR(address, null);
    }

    public static @Nullable VkAccelerationStructureDeviceAddressInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureDeviceAddressInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAccelerationStructureDeviceAddressInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureDeviceAddressInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureDeviceAddressInfoKHR malloc(MemoryStack stack) {
        return new VkAccelerationStructureDeviceAddressInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureDeviceAddressInfoKHR calloc(MemoryStack stack) {
        return new VkAccelerationStructureDeviceAddressInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long naccelerationStructure(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ACCELERATIONSTRUCTURE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void naccelerationStructure(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)ACCELERATIONSTRUCTURE, value);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureDeviceAddressInfoKHR.__struct(VkAccelerationStructureDeviceAddressInfoKHR.__member(4), VkAccelerationStructureDeviceAddressInfoKHR.__member(POINTER_SIZE), VkAccelerationStructureDeviceAddressInfoKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ACCELERATIONSTRUCTURE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureDeviceAddressInfoKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureDeviceAddressInfoKHR ELEMENT_FACTORY = VkAccelerationStructureDeviceAddressInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkAccelerationStructureDeviceAddressInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureDeviceAddressInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureDeviceAddressInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long accelerationStructure() {
            return VkAccelerationStructureDeviceAddressInfoKHR.naccelerationStructure(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureDeviceAddressInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureDeviceAddressInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer accelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkAccelerationStructureDeviceAddressInfoKHR.naccelerationStructure(this.address(), value);
            return this;
        }
    }
}

