/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkAccelerationStructureInstanceKHR;
import org.lwjgl.vulkan.VkTransformMatrixKHR;

public class VkAccelerationStructureInstanceNV
extends VkAccelerationStructureInstanceKHR {
    protected VkAccelerationStructureInstanceNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAccelerationStructureInstanceNV create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureInstanceNV(address, container);
    }

    public VkAccelerationStructureInstanceNV(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkAccelerationStructureInstanceNV transform(VkTransformMatrixKHR value) {
        VkAccelerationStructureInstanceNV.ntransform(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV transform(Consumer<VkTransformMatrixKHR> consumer) {
        consumer.accept(this.transform());
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV instanceCustomIndex(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceNV.ninstanceCustomIndex(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV mask(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceNV.nmask(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
        VkAccelerationStructureInstanceNV.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV accelerationStructureReference(@NativeType(value="uint64_t") long value) {
        VkAccelerationStructureInstanceNV.naccelerationStructureReference(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV set(VkTransformMatrixKHR transform, int instanceCustomIndex, int mask, int instanceShaderBindingTableRecordOffset, int flags, long accelerationStructureReference) {
        this.transform(transform);
        this.instanceCustomIndex(instanceCustomIndex);
        this.mask(mask);
        this.instanceShaderBindingTableRecordOffset(instanceShaderBindingTableRecordOffset);
        this.flags(flags);
        this.accelerationStructureReference(accelerationStructureReference);
        return this;
    }

    public VkAccelerationStructureInstanceNV set(VkAccelerationStructureInstanceNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureInstanceNV malloc() {
        return new VkAccelerationStructureInstanceNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAccelerationStructureInstanceNV calloc() {
        return new VkAccelerationStructureInstanceNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAccelerationStructureInstanceNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAccelerationStructureInstanceNV(MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureInstanceNV create(long address) {
        return new VkAccelerationStructureInstanceNV(address, null);
    }

    public static @Nullable VkAccelerationStructureInstanceNV createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureInstanceNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAccelerationStructureInstanceNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureInstanceNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureInstanceNV malloc(MemoryStack stack) {
        return new VkAccelerationStructureInstanceNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureInstanceNV calloc(MemoryStack stack) {
        return new VkAccelerationStructureInstanceNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkAccelerationStructureInstanceKHR.Buffer {
        private static final VkAccelerationStructureInstanceNV ELEMENT_FACTORY = VkAccelerationStructureInstanceNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkAccelerationStructureInstanceNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer transform(VkTransformMatrixKHR value) {
            VkAccelerationStructureInstanceNV.ntransform(this.address(), value);
            return this;
        }

        @Override
        public Buffer transform(Consumer<VkTransformMatrixKHR> consumer) {
            consumer.accept(this.transform());
            return this;
        }

        @Override
        public Buffer instanceCustomIndex(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceNV.ninstanceCustomIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer mask(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceNV.nmask(this.address(), value);
            return this;
        }

        @Override
        public Buffer instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
            VkAccelerationStructureInstanceNV.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer accelerationStructureReference(@NativeType(value="uint64_t") long value) {
            VkAccelerationStructureInstanceNV.naccelerationStructureReference(this.address(), value);
            return this;
        }
    }
}

