/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureInstanceKHR;
import org.lwjgl.vulkan.VkAccelerationStructureMatrixMotionInstanceNV;
import org.lwjgl.vulkan.VkAccelerationStructureSRTMotionInstanceNV;

public class VkAccelerationStructureMotionInstanceDataNV
extends Struct<VkAccelerationStructureMotionInstanceDataNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STATICINSTANCE;
    public static final int MATRIXMOTIONINSTANCE;
    public static final int SRTMOTIONINSTANCE;

    protected VkAccelerationStructureMotionInstanceDataNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAccelerationStructureMotionInstanceDataNV create(long address, @Nullable ByteBuffer container) {
        return new VkAccelerationStructureMotionInstanceDataNV(address, container);
    }

    public VkAccelerationStructureMotionInstanceDataNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureMotionInstanceDataNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkAccelerationStructureInstanceKHR staticInstance() {
        return VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address());
    }

    public VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance() {
        return VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address());
    }

    public VkAccelerationStructureSRTMotionInstanceNV srtMotionInstance() {
        return VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address());
    }

    public VkAccelerationStructureMotionInstanceDataNV staticInstance(VkAccelerationStructureInstanceKHR value) {
        VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV staticInstance(Consumer<VkAccelerationStructureInstanceKHR> consumer) {
        consumer.accept(this.staticInstance());
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV matrixMotionInstance(VkAccelerationStructureMatrixMotionInstanceNV value) {
        VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV matrixMotionInstance(Consumer<VkAccelerationStructureMatrixMotionInstanceNV> consumer) {
        consumer.accept(this.matrixMotionInstance());
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV srtMotionInstance(VkAccelerationStructureSRTMotionInstanceNV value) {
        VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV srtMotionInstance(Consumer<VkAccelerationStructureSRTMotionInstanceNV> consumer) {
        consumer.accept(this.srtMotionInstance());
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV set(VkAccelerationStructureMotionInstanceDataNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureMotionInstanceDataNV malloc() {
        return new VkAccelerationStructureMotionInstanceDataNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAccelerationStructureMotionInstanceDataNV calloc() {
        return new VkAccelerationStructureMotionInstanceDataNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAccelerationStructureMotionInstanceDataNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAccelerationStructureMotionInstanceDataNV(MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureMotionInstanceDataNV create(long address) {
        return new VkAccelerationStructureMotionInstanceDataNV(address, null);
    }

    public static @Nullable VkAccelerationStructureMotionInstanceDataNV createSafe(long address) {
        return address == 0L ? null : new VkAccelerationStructureMotionInstanceDataNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAccelerationStructureMotionInstanceDataNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureMotionInstanceDataNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAccelerationStructureMotionInstanceDataNV malloc(MemoryStack stack) {
        return new VkAccelerationStructureMotionInstanceDataNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAccelerationStructureMotionInstanceDataNV calloc(MemoryStack stack) {
        return new VkAccelerationStructureMotionInstanceDataNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkAccelerationStructureInstanceKHR nstaticInstance(long struct) {
        return VkAccelerationStructureInstanceKHR.create(struct + (long)STATICINSTANCE);
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV nmatrixMotionInstance(long struct) {
        return VkAccelerationStructureMatrixMotionInstanceNV.create(struct + (long)MATRIXMOTIONINSTANCE);
    }

    public static VkAccelerationStructureSRTMotionInstanceNV nsrtMotionInstance(long struct) {
        return VkAccelerationStructureSRTMotionInstanceNV.create(struct + (long)SRTMOTIONINSTANCE);
    }

    public static void nstaticInstance(long struct, VkAccelerationStructureInstanceKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)STATICINSTANCE, VkAccelerationStructureInstanceKHR.SIZEOF);
    }

    public static void nmatrixMotionInstance(long struct, VkAccelerationStructureMatrixMotionInstanceNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MATRIXMOTIONINSTANCE, VkAccelerationStructureMatrixMotionInstanceNV.SIZEOF);
    }

    public static void nsrtMotionInstance(long struct, VkAccelerationStructureSRTMotionInstanceNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRTMOTIONINSTANCE, VkAccelerationStructureSRTMotionInstanceNV.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureMotionInstanceDataNV.__union(VkAccelerationStructureMotionInstanceDataNV.__member(VkAccelerationStructureInstanceKHR.SIZEOF, VkAccelerationStructureInstanceKHR.ALIGNOF), VkAccelerationStructureMotionInstanceDataNV.__member(VkAccelerationStructureMatrixMotionInstanceNV.SIZEOF, VkAccelerationStructureMatrixMotionInstanceNV.ALIGNOF), VkAccelerationStructureMotionInstanceDataNV.__member(VkAccelerationStructureSRTMotionInstanceNV.SIZEOF, VkAccelerationStructureSRTMotionInstanceNV.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STATICINSTANCE = layout.offsetof(0);
        MATRIXMOTIONINSTANCE = layout.offsetof(1);
        SRTMOTIONINSTANCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureMotionInstanceDataNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureMotionInstanceDataNV ELEMENT_FACTORY = VkAccelerationStructureMotionInstanceDataNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkAccelerationStructureMotionInstanceDataNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkAccelerationStructureInstanceKHR staticInstance() {
            return VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address());
        }

        public VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance() {
            return VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address());
        }

        public VkAccelerationStructureSRTMotionInstanceNV srtMotionInstance() {
            return VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address());
        }

        public Buffer staticInstance(VkAccelerationStructureInstanceKHR value) {
            VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address(), value);
            return this;
        }

        public Buffer staticInstance(Consumer<VkAccelerationStructureInstanceKHR> consumer) {
            consumer.accept(this.staticInstance());
            return this;
        }

        public Buffer matrixMotionInstance(VkAccelerationStructureMatrixMotionInstanceNV value) {
            VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address(), value);
            return this;
        }

        public Buffer matrixMotionInstance(Consumer<VkAccelerationStructureMatrixMotionInstanceNV> consumer) {
            consumer.accept(this.matrixMotionInstance());
            return this;
        }

        public Buffer srtMotionInstance(VkAccelerationStructureSRTMotionInstanceNV value) {
            VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address(), value);
            return this;
        }

        public Buffer srtMotionInstance(Consumer<VkAccelerationStructureSRTMotionInstanceNV> consumer) {
            consumer.accept(this.srtMotionInstance());
            return this;
        }
    }
}

