/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAntiLagPresentationInfoAMD;

public class VkAntiLagDataAMD
extends Struct<VkAntiLagDataAMD>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MODE;
    public static final int MAXFPS;
    public static final int PPRESENTATIONINFO;

    protected VkAntiLagDataAMD(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkAntiLagDataAMD create(long address, @Nullable ByteBuffer container) {
        return new VkAntiLagDataAMD(address, container);
    }

    public VkAntiLagDataAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAntiLagDataAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAntiLagDataAMD.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAntiLagDataAMD.npNext(this.address());
    }

    @NativeType(value="VkAntiLagModeAMD")
    public int mode() {
        return VkAntiLagDataAMD.nmode(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxFPS() {
        return VkAntiLagDataAMD.nmaxFPS(this.address());
    }

    @NativeType(value="VkAntiLagPresentationInfoAMD const *")
    public @Nullable VkAntiLagPresentationInfoAMD pPresentationInfo() {
        return VkAntiLagDataAMD.npPresentationInfo(this.address());
    }

    public VkAntiLagDataAMD sType(@NativeType(value="VkStructureType") int value) {
        VkAntiLagDataAMD.nsType(this.address(), value);
        return this;
    }

    public VkAntiLagDataAMD sType$Default() {
        return this.sType(1000476001);
    }

    public VkAntiLagDataAMD pNext(@NativeType(value="void const *") long value) {
        VkAntiLagDataAMD.npNext(this.address(), value);
        return this;
    }

    public VkAntiLagDataAMD mode(@NativeType(value="VkAntiLagModeAMD") int value) {
        VkAntiLagDataAMD.nmode(this.address(), value);
        return this;
    }

    public VkAntiLagDataAMD maxFPS(@NativeType(value="uint32_t") int value) {
        VkAntiLagDataAMD.nmaxFPS(this.address(), value);
        return this;
    }

    public VkAntiLagDataAMD pPresentationInfo(@NativeType(value="VkAntiLagPresentationInfoAMD const *") @Nullable VkAntiLagPresentationInfoAMD value) {
        VkAntiLagDataAMD.npPresentationInfo(this.address(), value);
        return this;
    }

    public VkAntiLagDataAMD set(int sType, long pNext, int mode, int maxFPS, @Nullable VkAntiLagPresentationInfoAMD pPresentationInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.mode(mode);
        this.maxFPS(maxFPS);
        this.pPresentationInfo(pPresentationInfo);
        return this;
    }

    public VkAntiLagDataAMD set(VkAntiLagDataAMD src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAntiLagDataAMD malloc() {
        return new VkAntiLagDataAMD(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkAntiLagDataAMD calloc() {
        return new VkAntiLagDataAMD(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkAntiLagDataAMD create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkAntiLagDataAMD(MemoryUtil.memAddress(container), container);
    }

    public static VkAntiLagDataAMD create(long address) {
        return new VkAntiLagDataAMD(address, null);
    }

    public static @Nullable VkAntiLagDataAMD createSafe(long address) {
        return address == 0L ? null : new VkAntiLagDataAMD(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkAntiLagDataAMD.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAntiLagDataAMD.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkAntiLagDataAMD malloc(MemoryStack stack) {
        return new VkAntiLagDataAMD(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkAntiLagDataAMD calloc(MemoryStack stack) {
        return new VkAntiLagDataAMD(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MODE);
    }

    public static int nmaxFPS(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFPS);
    }

    public static @Nullable VkAntiLagPresentationInfoAMD npPresentationInfo(long struct) {
        return VkAntiLagPresentationInfoAMD.createSafe(MemoryUtil.memGetAddress(struct + (long)PPRESENTATIONINFO));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MODE, value);
    }

    public static void nmaxFPS(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXFPS, value);
    }

    public static void npPresentationInfo(long struct, @Nullable VkAntiLagPresentationInfoAMD value) {
        MemoryUtil.memPutAddress(struct + (long)PPRESENTATIONINFO, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkAntiLagDataAMD.__struct(VkAntiLagDataAMD.__member(4), VkAntiLagDataAMD.__member(POINTER_SIZE), VkAntiLagDataAMD.__member(4), VkAntiLagDataAMD.__member(4), VkAntiLagDataAMD.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MODE = layout.offsetof(2);
        MAXFPS = layout.offsetof(3);
        PPRESENTATIONINFO = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAntiLagDataAMD, Buffer>
    implements NativeResource {
        private static final VkAntiLagDataAMD ELEMENT_FACTORY = VkAntiLagDataAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkAntiLagDataAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAntiLagDataAMD.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAntiLagDataAMD.npNext(this.address());
        }

        @NativeType(value="VkAntiLagModeAMD")
        public int mode() {
            return VkAntiLagDataAMD.nmode(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxFPS() {
            return VkAntiLagDataAMD.nmaxFPS(this.address());
        }

        @NativeType(value="VkAntiLagPresentationInfoAMD const *")
        public @Nullable VkAntiLagPresentationInfoAMD pPresentationInfo() {
            return VkAntiLagDataAMD.npPresentationInfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAntiLagDataAMD.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000476001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAntiLagDataAMD.npNext(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkAntiLagModeAMD") int value) {
            VkAntiLagDataAMD.nmode(this.address(), value);
            return this;
        }

        public Buffer maxFPS(@NativeType(value="uint32_t") int value) {
            VkAntiLagDataAMD.nmaxFPS(this.address(), value);
            return this;
        }

        public Buffer pPresentationInfo(@NativeType(value="VkAntiLagPresentationInfoAMD const *") @Nullable VkAntiLagPresentationInfoAMD value) {
            VkAntiLagDataAMD.npPresentationInfo(this.address(), value);
            return this;
        }
    }
}

