/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBaseInStructure
extends Struct<VkBaseInStructure>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;

    protected VkBaseInStructure(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBaseInStructure create(long address, @Nullable ByteBuffer container) {
        return new VkBaseInStructure(address, container);
    }

    public VkBaseInStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBaseInStructure.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBaseInStructure.nsType(this.address());
    }

    @NativeType(value="VkBaseInStructure const *")
    public @Nullable VkBaseInStructure pNext() {
        return VkBaseInStructure.npNext(this.address());
    }

    public VkBaseInStructure sType(@NativeType(value="VkStructureType") int value) {
        VkBaseInStructure.nsType(this.address(), value);
        return this;
    }

    public VkBaseInStructure pNext(@NativeType(value="VkBaseInStructure const *") @Nullable VkBaseInStructure value) {
        VkBaseInStructure.npNext(this.address(), value);
        return this;
    }

    public VkBaseInStructure set(int sType, @Nullable VkBaseInStructure pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkBaseInStructure set(VkBaseInStructure src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBaseInStructure malloc() {
        return new VkBaseInStructure(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBaseInStructure calloc() {
        return new VkBaseInStructure(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBaseInStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBaseInStructure(MemoryUtil.memAddress(container), container);
    }

    public static VkBaseInStructure create(long address) {
        return new VkBaseInStructure(address, null);
    }

    public static @Nullable VkBaseInStructure createSafe(long address) {
        return address == 0L ? null : new VkBaseInStructure(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBaseInStructure.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBaseInStructure.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBaseInStructure mallocStack() {
        return VkBaseInStructure.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseInStructure callocStack() {
        return VkBaseInStructure.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBaseInStructure mallocStack(MemoryStack stack) {
        return VkBaseInStructure.malloc(stack);
    }

    @Deprecated
    public static VkBaseInStructure callocStack(MemoryStack stack) {
        return VkBaseInStructure.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBaseInStructure.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBaseInStructure.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBaseInStructure.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBaseInStructure.calloc(capacity, stack);
    }

    public static VkBaseInStructure malloc(MemoryStack stack) {
        return new VkBaseInStructure(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBaseInStructure calloc(MemoryStack stack) {
        return new VkBaseInStructure(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static @Nullable VkBaseInStructure npNext(long struct) {
        return VkBaseInStructure.createSafe(MemoryUtil.memGetAddress(struct + (long)PNEXT));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, @Nullable VkBaseInStructure value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkBaseInStructure.__struct(VkBaseInStructure.__member(4), VkBaseInStructure.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkBaseInStructure, Buffer>
    implements NativeResource {
        private static final VkBaseInStructure ELEMENT_FACTORY = VkBaseInStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBaseInStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBaseInStructure.nsType(this.address());
        }

        @NativeType(value="VkBaseInStructure const *")
        public @Nullable VkBaseInStructure pNext() {
            return VkBaseInStructure.npNext(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBaseInStructure.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="VkBaseInStructure const *") @Nullable VkBaseInStructure value) {
            VkBaseInStructure.npNext(this.address(), value);
            return this;
        }
    }
}

