/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;

public class VkBindDescriptorSetsInfo
extends Struct<VkBindDescriptorSetsInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGEFLAGS;
    public static final int LAYOUT;
    public static final int FIRSTSET;
    public static final int DESCRIPTORSETCOUNT;
    public static final int PDESCRIPTORSETS;
    public static final int DYNAMICOFFSETCOUNT;
    public static final int PDYNAMICOFFSETS;

    protected VkBindDescriptorSetsInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindDescriptorSetsInfo create(long address, @Nullable ByteBuffer container) {
        return new VkBindDescriptorSetsInfo(address, container);
    }

    public VkBindDescriptorSetsInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindDescriptorSetsInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindDescriptorSetsInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindDescriptorSetsInfo.npNext(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkBindDescriptorSetsInfo.nstageFlags(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkBindDescriptorSetsInfo.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstSet() {
        return VkBindDescriptorSetsInfo.nfirstSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorSetCount() {
        return VkBindDescriptorSetsInfo.ndescriptorSetCount(this.address());
    }

    @NativeType(value="VkDescriptorSet const *")
    public LongBuffer pDescriptorSets() {
        return VkBindDescriptorSetsInfo.npDescriptorSets(this.address());
    }

    @NativeType(value="uint32_t")
    public int dynamicOffsetCount() {
        return VkBindDescriptorSetsInfo.ndynamicOffsetCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pDynamicOffsets() {
        return VkBindDescriptorSetsInfo.npDynamicOffsets(this.address());
    }

    public VkBindDescriptorSetsInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindDescriptorSetsInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo sType$Default() {
        return this.sType(1000545003);
    }

    public VkBindDescriptorSetsInfo pNext(@NativeType(value="void const *") long value) {
        VkBindDescriptorSetsInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindDescriptorSetsInfo stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkBindDescriptorSetsInfo.nstageFlags(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo layout(@NativeType(value="VkPipelineLayout") long value) {
        VkBindDescriptorSetsInfo.nlayout(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo firstSet(@NativeType(value="uint32_t") int value) {
        VkBindDescriptorSetsInfo.nfirstSet(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo pDescriptorSets(@NativeType(value="VkDescriptorSet const *") LongBuffer value) {
        VkBindDescriptorSetsInfo.npDescriptorSets(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo dynamicOffsetCount(@NativeType(value="uint32_t") int value) {
        VkBindDescriptorSetsInfo.ndynamicOffsetCount(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo pDynamicOffsets(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkBindDescriptorSetsInfo.npDynamicOffsets(this.address(), value);
        return this;
    }

    public VkBindDescriptorSetsInfo set(int sType, long pNext, int stageFlags, long layout, int firstSet, LongBuffer pDescriptorSets, int dynamicOffsetCount, @Nullable IntBuffer pDynamicOffsets) {
        this.sType(sType);
        this.pNext(pNext);
        this.stageFlags(stageFlags);
        this.layout(layout);
        this.firstSet(firstSet);
        this.pDescriptorSets(pDescriptorSets);
        this.dynamicOffsetCount(dynamicOffsetCount);
        this.pDynamicOffsets(pDynamicOffsets);
        return this;
    }

    public VkBindDescriptorSetsInfo set(VkBindDescriptorSetsInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindDescriptorSetsInfo malloc() {
        return new VkBindDescriptorSetsInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindDescriptorSetsInfo calloc() {
        return new VkBindDescriptorSetsInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindDescriptorSetsInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindDescriptorSetsInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkBindDescriptorSetsInfo create(long address) {
        return new VkBindDescriptorSetsInfo(address, null);
    }

    public static @Nullable VkBindDescriptorSetsInfo createSafe(long address) {
        return address == 0L ? null : new VkBindDescriptorSetsInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindDescriptorSetsInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindDescriptorSetsInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindDescriptorSetsInfo malloc(MemoryStack stack) {
        return new VkBindDescriptorSetsInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindDescriptorSetsInfo calloc(MemoryStack stack) {
        return new VkBindDescriptorSetsInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGEFLAGS);
    }

    public static long nlayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYOUT);
    }

    public static int nfirstSet(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTSET);
    }

    public static int ndescriptorSetCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORSETCOUNT);
    }

    public static LongBuffer npDescriptorSets(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORSETS), VkBindDescriptorSetsInfo.ndescriptorSetCount(struct));
    }

    public static int ndynamicOffsetCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DYNAMICOFFSETCOUNT);
    }

    public static @Nullable IntBuffer npDynamicOffsets(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDYNAMICOFFSETS), VkBindDescriptorSetsInfo.ndynamicOffsetCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nstageFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGEFLAGS, value);
    }

    public static void nlayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYOUT, value);
    }

    public static void nfirstSet(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTSET, value);
    }

    public static void ndescriptorSetCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORSETCOUNT, value);
    }

    public static void npDescriptorSets(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDESCRIPTORSETS, MemoryUtil.memAddress(value));
        VkBindDescriptorSetsInfo.ndescriptorSetCount(struct, value.remaining());
    }

    public static void ndynamicOffsetCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DYNAMICOFFSETCOUNT, value);
    }

    public static void npDynamicOffsets(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDYNAMICOFFSETS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkBindDescriptorSetsInfo.ndynamicOffsetCount(struct, value.remaining());
        }
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORSETS));
    }

    static {
        Struct.Layout layout = VkBindDescriptorSetsInfo.__struct(VkBindDescriptorSetsInfo.__member(4), VkBindDescriptorSetsInfo.__member(POINTER_SIZE), VkBindDescriptorSetsInfo.__member(4), VkBindDescriptorSetsInfo.__member(8), VkBindDescriptorSetsInfo.__member(4), VkBindDescriptorSetsInfo.__member(4), VkBindDescriptorSetsInfo.__member(POINTER_SIZE), VkBindDescriptorSetsInfo.__member(4), VkBindDescriptorSetsInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGEFLAGS = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        FIRSTSET = layout.offsetof(4);
        DESCRIPTORSETCOUNT = layout.offsetof(5);
        PDESCRIPTORSETS = layout.offsetof(6);
        DYNAMICOFFSETCOUNT = layout.offsetof(7);
        PDYNAMICOFFSETS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkBindDescriptorSetsInfo, Buffer>
    implements NativeResource {
        private static final VkBindDescriptorSetsInfo ELEMENT_FACTORY = VkBindDescriptorSetsInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBindDescriptorSetsInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindDescriptorSetsInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindDescriptorSetsInfo.npNext(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkBindDescriptorSetsInfo.nstageFlags(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkBindDescriptorSetsInfo.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstSet() {
            return VkBindDescriptorSetsInfo.nfirstSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorSetCount() {
            return VkBindDescriptorSetsInfo.ndescriptorSetCount(this.address());
        }

        @NativeType(value="VkDescriptorSet const *")
        public LongBuffer pDescriptorSets() {
            return VkBindDescriptorSetsInfo.npDescriptorSets(this.address());
        }

        @NativeType(value="uint32_t")
        public int dynamicOffsetCount() {
            return VkBindDescriptorSetsInfo.ndynamicOffsetCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pDynamicOffsets() {
            return VkBindDescriptorSetsInfo.npDynamicOffsets(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindDescriptorSetsInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindDescriptorSetsInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkBindDescriptorSetsInfo.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkBindDescriptorSetsInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer firstSet(@NativeType(value="uint32_t") int value) {
            VkBindDescriptorSetsInfo.nfirstSet(this.address(), value);
            return this;
        }

        public Buffer pDescriptorSets(@NativeType(value="VkDescriptorSet const *") LongBuffer value) {
            VkBindDescriptorSetsInfo.npDescriptorSets(this.address(), value);
            return this;
        }

        public Buffer dynamicOffsetCount(@NativeType(value="uint32_t") int value) {
            VkBindDescriptorSetsInfo.ndynamicOffsetCount(this.address(), value);
            return this;
        }

        public Buffer pDynamicOffsets(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkBindDescriptorSetsInfo.npDynamicOffsets(this.address(), value);
            return this;
        }
    }
}

