/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBindImageMemoryDeviceGroupInfo;
import org.lwjgl.vulkan.VkBindImageMemoryDeviceGroupInfoKHR;
import org.lwjgl.vulkan.VkBindImageMemorySwapchainInfoKHR;
import org.lwjgl.vulkan.VkBindImagePlaneMemoryInfo;
import org.lwjgl.vulkan.VkBindImagePlaneMemoryInfoKHR;
import org.lwjgl.vulkan.VkBindMemoryStatus;
import org.lwjgl.vulkan.VkBindMemoryStatusKHR;

public class VkBindImageMemoryInfo
extends Struct<VkBindImageMemoryInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;

    protected VkBindImageMemoryInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindImageMemoryInfo create(long address, @Nullable ByteBuffer container) {
        return new VkBindImageMemoryInfo(address, container);
    }

    public VkBindImageMemoryInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindImageMemoryInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindImageMemoryInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindImageMemoryInfo.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkBindImageMemoryInfo.nimage(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkBindImageMemoryInfo.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkBindImageMemoryInfo.nmemoryOffset(this.address());
    }

    public VkBindImageMemoryInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindImageMemoryInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfo sType$Default() {
        return this.sType(1000157001);
    }

    public VkBindImageMemoryInfo pNext(@NativeType(value="void const *") long value) {
        VkBindImageMemoryInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfo pNext(VkBindImageMemoryDeviceGroupInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindImageMemoryInfo pNext(VkBindImageMemoryDeviceGroupInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindImageMemoryInfo pNext(VkBindImageMemorySwapchainInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindImageMemoryInfo pNext(VkBindImagePlaneMemoryInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindImageMemoryInfo pNext(VkBindImagePlaneMemoryInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindImageMemoryInfo pNext(VkBindMemoryStatus value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindImageMemoryInfo pNext(VkBindMemoryStatusKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBindImageMemoryInfo image(@NativeType(value="VkImage") long value) {
        VkBindImageMemoryInfo.nimage(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkBindImageMemoryInfo.nmemory(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfo memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBindImageMemoryInfo.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkBindImageMemoryInfo set(int sType, long pNext, long image, long memory, long memoryOffset) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        return this;
    }

    public VkBindImageMemoryInfo set(VkBindImageMemoryInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindImageMemoryInfo malloc() {
        return new VkBindImageMemoryInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindImageMemoryInfo calloc() {
        return new VkBindImageMemoryInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindImageMemoryInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindImageMemoryInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkBindImageMemoryInfo create(long address) {
        return new VkBindImageMemoryInfo(address, null);
    }

    public static @Nullable VkBindImageMemoryInfo createSafe(long address) {
        return address == 0L ? null : new VkBindImageMemoryInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindImageMemoryInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImageMemoryInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkBindImageMemoryInfo mallocStack() {
        return VkBindImageMemoryInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImageMemoryInfo callocStack() {
        return VkBindImageMemoryInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBindImageMemoryInfo mallocStack(MemoryStack stack) {
        return VkBindImageMemoryInfo.malloc(stack);
    }

    @Deprecated
    public static VkBindImageMemoryInfo callocStack(MemoryStack stack) {
        return VkBindImageMemoryInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBindImageMemoryInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBindImageMemoryInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBindImageMemoryInfo.calloc(capacity, stack);
    }

    public static VkBindImageMemoryInfo malloc(MemoryStack stack) {
        return new VkBindImageMemoryInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindImageMemoryInfo calloc(MemoryStack stack) {
        return new VkBindImageMemoryInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORYOFFSET);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORYOFFSET, value);
    }

    static {
        Struct.Layout layout = VkBindImageMemoryInfo.__struct(VkBindImageMemoryInfo.__member(4), VkBindImageMemoryInfo.__member(POINTER_SIZE), VkBindImageMemoryInfo.__member(8), VkBindImageMemoryInfo.__member(8), VkBindImageMemoryInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkBindImageMemoryInfo, Buffer>
    implements NativeResource {
        private static final VkBindImageMemoryInfo ELEMENT_FACTORY = VkBindImageMemoryInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBindImageMemoryInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindImageMemoryInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindImageMemoryInfo.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkBindImageMemoryInfo.nimage(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkBindImageMemoryInfo.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkBindImageMemoryInfo.nmemoryOffset(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImageMemoryInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000157001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImageMemoryInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkBindImageMemoryDeviceGroupInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindImageMemoryDeviceGroupInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindImageMemorySwapchainInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindImagePlaneMemoryInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindImagePlaneMemoryInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindMemoryStatus value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkBindMemoryStatusKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkBindImageMemoryInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkBindImageMemoryInfo.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBindImageMemoryInfo.nmemoryOffset(this.address(), value);
            return this;
        }
    }
}

