/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindMemoryStatus
extends Struct<VkBindMemoryStatus>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PRESULT;

    protected VkBindMemoryStatus(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindMemoryStatus create(long address, @Nullable ByteBuffer container) {
        return new VkBindMemoryStatus(address, container);
    }

    public VkBindMemoryStatus(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindMemoryStatus.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindMemoryStatus.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindMemoryStatus.npNext(this.address());
    }

    @NativeType(value="VkResult *")
    public IntBuffer pResult(int capacity) {
        return VkBindMemoryStatus.npResult(this.address(), capacity);
    }

    public VkBindMemoryStatus sType(@NativeType(value="VkStructureType") int value) {
        VkBindMemoryStatus.nsType(this.address(), value);
        return this;
    }

    public VkBindMemoryStatus sType$Default() {
        return this.sType(1000545002);
    }

    public VkBindMemoryStatus pNext(@NativeType(value="void const *") long value) {
        VkBindMemoryStatus.npNext(this.address(), value);
        return this;
    }

    public VkBindMemoryStatus pResult(@NativeType(value="VkResult *") IntBuffer value) {
        VkBindMemoryStatus.npResult(this.address(), value);
        return this;
    }

    public VkBindMemoryStatus set(int sType, long pNext, IntBuffer pResult) {
        this.sType(sType);
        this.pNext(pNext);
        this.pResult(pResult);
        return this;
    }

    public VkBindMemoryStatus set(VkBindMemoryStatus src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindMemoryStatus malloc() {
        return new VkBindMemoryStatus(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindMemoryStatus calloc() {
        return new VkBindMemoryStatus(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindMemoryStatus create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindMemoryStatus(MemoryUtil.memAddress(container), container);
    }

    public static VkBindMemoryStatus create(long address) {
        return new VkBindMemoryStatus(address, null);
    }

    public static @Nullable VkBindMemoryStatus createSafe(long address) {
        return address == 0L ? null : new VkBindMemoryStatus(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindMemoryStatus.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindMemoryStatus.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindMemoryStatus malloc(MemoryStack stack) {
        return new VkBindMemoryStatus(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindMemoryStatus calloc(MemoryStack stack) {
        return new VkBindMemoryStatus(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static IntBuffer npResult(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PRESULT), capacity);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npResult(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRESULT, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PRESULT));
    }

    static {
        Struct.Layout layout = VkBindMemoryStatus.__struct(VkBindMemoryStatus.__member(4), VkBindMemoryStatus.__member(POINTER_SIZE), VkBindMemoryStatus.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PRESULT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindMemoryStatus, Buffer>
    implements NativeResource {
        private static final VkBindMemoryStatus ELEMENT_FACTORY = VkBindMemoryStatus.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBindMemoryStatus getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindMemoryStatus.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindMemoryStatus.npNext(this.address());
        }

        @NativeType(value="VkResult *")
        public IntBuffer pResult(int capacity) {
            return VkBindMemoryStatus.npResult(this.address(), capacity);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindMemoryStatus.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindMemoryStatus.npNext(this.address(), value);
            return this;
        }

        public Buffer pResult(@NativeType(value="VkResult *") IntBuffer value) {
            VkBindMemoryStatus.npResult(this.address(), value);
            return this;
        }
    }
}

