/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindVertexBufferIndirectCommandEXT
extends Struct<VkBindVertexBufferIndirectCommandEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFERADDRESS;
    public static final int SIZE;
    public static final int STRIDE;

    protected VkBindVertexBufferIndirectCommandEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBindVertexBufferIndirectCommandEXT create(long address, @Nullable ByteBuffer container) {
        return new VkBindVertexBufferIndirectCommandEXT(address, container);
    }

    public VkBindVertexBufferIndirectCommandEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBindVertexBufferIndirectCommandEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long bufferAddress() {
        return VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkBindVertexBufferIndirectCommandEXT.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int stride() {
        return VkBindVertexBufferIndirectCommandEXT.nstride(this.address());
    }

    public VkBindVertexBufferIndirectCommandEXT bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT size(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandEXT.nsize(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT stride(@NativeType(value="uint32_t") int value) {
        VkBindVertexBufferIndirectCommandEXT.nstride(this.address(), value);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT set(long bufferAddress, int size, int stride) {
        this.bufferAddress(bufferAddress);
        this.size(size);
        this.stride(stride);
        return this;
    }

    public VkBindVertexBufferIndirectCommandEXT set(VkBindVertexBufferIndirectCommandEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBindVertexBufferIndirectCommandEXT malloc() {
        return new VkBindVertexBufferIndirectCommandEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBindVertexBufferIndirectCommandEXT calloc() {
        return new VkBindVertexBufferIndirectCommandEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBindVertexBufferIndirectCommandEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBindVertexBufferIndirectCommandEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkBindVertexBufferIndirectCommandEXT create(long address) {
        return new VkBindVertexBufferIndirectCommandEXT(address, null);
    }

    public static @Nullable VkBindVertexBufferIndirectCommandEXT createSafe(long address) {
        return address == 0L ? null : new VkBindVertexBufferIndirectCommandEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBindVertexBufferIndirectCommandEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindVertexBufferIndirectCommandEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindVertexBufferIndirectCommandEXT malloc(MemoryStack stack) {
        return new VkBindVertexBufferIndirectCommandEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindVertexBufferIndirectCommandEXT calloc(MemoryStack stack) {
        return new VkBindVertexBufferIndirectCommandEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbufferAddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFERADDRESS);
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static int nstride(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STRIDE);
    }

    public static void nbufferAddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFERADDRESS, value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void nstride(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STRIDE, value);
    }

    static {
        Struct.Layout layout = VkBindVertexBufferIndirectCommandEXT.__struct(VkBindVertexBufferIndirectCommandEXT.__member(8), VkBindVertexBufferIndirectCommandEXT.__member(4), VkBindVertexBufferIndirectCommandEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFERADDRESS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindVertexBufferIndirectCommandEXT, Buffer>
    implements NativeResource {
        private static final VkBindVertexBufferIndirectCommandEXT ELEMENT_FACTORY = VkBindVertexBufferIndirectCommandEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBindVertexBufferIndirectCommandEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long bufferAddress() {
            return VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkBindVertexBufferIndirectCommandEXT.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int stride() {
            return VkBindVertexBufferIndirectCommandEXT.nstride(this.address());
        }

        public Buffer bufferAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBindVertexBufferIndirectCommandEXT.nbufferAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandEXT.nsize(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint32_t") int value) {
            VkBindVertexBufferIndirectCommandEXT.nstride(this.address(), value);
            return this;
        }
    }
}

