/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCopy2
extends Struct<VkBufferCopy2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCOFFSET;
    public static final int DSTOFFSET;
    public static final int SIZE;

    protected VkBufferCopy2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBufferCopy2 create(long address, @Nullable ByteBuffer container) {
        return new VkBufferCopy2(address, container);
    }

    public VkBufferCopy2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferCopy2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferCopy2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferCopy2.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long srcOffset() {
        return VkBufferCopy2.nsrcOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstOffset() {
        return VkBufferCopy2.ndstOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferCopy2.nsize(this.address());
    }

    public VkBufferCopy2 sType(@NativeType(value="VkStructureType") int value) {
        VkBufferCopy2.nsType(this.address(), value);
        return this;
    }

    public VkBufferCopy2 sType$Default() {
        return this.sType(1000337006);
    }

    public VkBufferCopy2 pNext(@NativeType(value="void const *") long value) {
        VkBufferCopy2.npNext(this.address(), value);
        return this;
    }

    public VkBufferCopy2 srcOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2.nsrcOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy2 dstOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2.ndstOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy2 size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2.nsize(this.address(), value);
        return this;
    }

    public VkBufferCopy2 set(int sType, long pNext, long srcOffset, long dstOffset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcOffset(srcOffset);
        this.dstOffset(dstOffset);
        this.size(size);
        return this;
    }

    public VkBufferCopy2 set(VkBufferCopy2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferCopy2 malloc() {
        return new VkBufferCopy2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBufferCopy2 calloc() {
        return new VkBufferCopy2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBufferCopy2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBufferCopy2(MemoryUtil.memAddress(container), container);
    }

    public static VkBufferCopy2 create(long address) {
        return new VkBufferCopy2(address, null);
    }

    public static @Nullable VkBufferCopy2 createSafe(long address) {
        return address == 0L ? null : new VkBufferCopy2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBufferCopy2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCopy2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBufferCopy2 malloc(MemoryStack stack) {
        return new VkBufferCopy2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferCopy2 calloc(MemoryStack stack) {
        return new VkBufferCopy2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsrcOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCOFFSET);
    }

    public static long ndstOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTOFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCOFFSET, value);
    }

    public static void ndstOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTOFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkBufferCopy2.__struct(VkBufferCopy2.__member(4), VkBufferCopy2.__member(POINTER_SIZE), VkBufferCopy2.__member(8), VkBufferCopy2.__member(8), VkBufferCopy2.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCOFFSET = layout.offsetof(2);
        DSTOFFSET = layout.offsetof(3);
        SIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCopy2, Buffer>
    implements NativeResource {
        private static final VkBufferCopy2 ELEMENT_FACTORY = VkBufferCopy2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkBufferCopy2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferCopy2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferCopy2.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long srcOffset() {
            return VkBufferCopy2.nsrcOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstOffset() {
            return VkBufferCopy2.ndstOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferCopy2.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferCopy2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferCopy2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2.nsize(this.address(), value);
            return this;
        }
    }
}

