/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearColorValue;
import org.lwjgl.vulkan.VkClearDepthStencilValue;

public class VkClearValue
extends Struct<VkClearValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int DEPTHSTENCIL;

    protected VkClearValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkClearValue create(long address, @Nullable ByteBuffer container) {
        return new VkClearValue(address, container);
    }

    public VkClearValue(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkClearValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkClearColorValue color() {
        return VkClearValue.ncolor(this.address());
    }

    public VkClearDepthStencilValue depthStencil() {
        return VkClearValue.ndepthStencil(this.address());
    }

    public VkClearValue color(VkClearColorValue value) {
        VkClearValue.ncolor(this.address(), value);
        return this;
    }

    public VkClearValue color(Consumer<VkClearColorValue> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public VkClearValue depthStencil(VkClearDepthStencilValue value) {
        VkClearValue.ndepthStencil(this.address(), value);
        return this;
    }

    public VkClearValue depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
        consumer.accept(this.depthStencil());
        return this;
    }

    public VkClearValue set(VkClearValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearValue malloc() {
        return new VkClearValue(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkClearValue calloc() {
        return new VkClearValue(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkClearValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkClearValue(MemoryUtil.memAddress(container), container);
    }

    public static VkClearValue create(long address) {
        return new VkClearValue(address, null);
    }

    public static @Nullable VkClearValue createSafe(long address) {
        return address == 0L ? null : new VkClearValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkClearValue.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearValue.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkClearValue mallocStack() {
        return VkClearValue.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearValue callocStack() {
        return VkClearValue.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearValue mallocStack(MemoryStack stack) {
        return VkClearValue.malloc(stack);
    }

    @Deprecated
    public static VkClearValue callocStack(MemoryStack stack) {
        return VkClearValue.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkClearValue.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkClearValue.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearValue.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearValue.calloc(capacity, stack);
    }

    public static VkClearValue malloc(MemoryStack stack) {
        return new VkClearValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkClearValue calloc(MemoryStack stack) {
        return new VkClearValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkClearColorValue ncolor(long struct) {
        return VkClearColorValue.create(struct + (long)COLOR);
    }

    public static VkClearDepthStencilValue ndepthStencil(long struct) {
        return VkClearDepthStencilValue.create(struct + (long)DEPTHSTENCIL);
    }

    public static void ncolor(long struct, VkClearColorValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, VkClearColorValue.SIZEOF);
    }

    public static void ndepthStencil(long struct, VkClearDepthStencilValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEPTHSTENCIL, VkClearDepthStencilValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearValue.__union(VkClearValue.__member(VkClearColorValue.SIZEOF, VkClearColorValue.ALIGNOF), VkClearValue.__member(VkClearDepthStencilValue.SIZEOF, VkClearDepthStencilValue.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        DEPTHSTENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearValue, Buffer>
    implements NativeResource {
        private static final VkClearValue ELEMENT_FACTORY = VkClearValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkClearValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkClearColorValue color() {
            return VkClearValue.ncolor(this.address());
        }

        public VkClearDepthStencilValue depthStencil() {
            return VkClearValue.ndepthStencil(this.address());
        }

        public Buffer color(VkClearColorValue value) {
            VkClearValue.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<VkClearColorValue> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer depthStencil(VkClearDepthStencilValue value) {
            VkClearValue.ndepthStencil(this.address(), value);
            return this;
        }

        public Buffer depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
            consumer.accept(this.depthStencil());
            return this;
        }
    }
}

