/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCoarseSampleLocationNV;

public class VkCoarseSampleOrderCustomNV
extends Struct<VkCoarseSampleOrderCustomNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SHADINGRATE;
    public static final int SAMPLECOUNT;
    public static final int SAMPLELOCATIONCOUNT;
    public static final int PSAMPLELOCATIONS;

    protected VkCoarseSampleOrderCustomNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCoarseSampleOrderCustomNV create(long address, @Nullable ByteBuffer container) {
        return new VkCoarseSampleOrderCustomNV(address, container);
    }

    public VkCoarseSampleOrderCustomNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCoarseSampleOrderCustomNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkShadingRatePaletteEntryNV")
    public int shadingRate() {
        return VkCoarseSampleOrderCustomNV.nshadingRate(this.address());
    }

    @NativeType(value="uint32_t")
    public int sampleCount() {
        return VkCoarseSampleOrderCustomNV.nsampleCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int sampleLocationCount() {
        return VkCoarseSampleOrderCustomNV.nsampleLocationCount(this.address());
    }

    @NativeType(value="VkCoarseSampleLocationNV const *")
    public VkCoarseSampleLocationNV.Buffer pSampleLocations() {
        return VkCoarseSampleOrderCustomNV.npSampleLocations(this.address());
    }

    public VkCoarseSampleOrderCustomNV shadingRate(@NativeType(value="VkShadingRatePaletteEntryNV") int value) {
        VkCoarseSampleOrderCustomNV.nshadingRate(this.address(), value);
        return this;
    }

    public VkCoarseSampleOrderCustomNV sampleCount(@NativeType(value="uint32_t") int value) {
        VkCoarseSampleOrderCustomNV.nsampleCount(this.address(), value);
        return this;
    }

    public VkCoarseSampleOrderCustomNV pSampleLocations(@NativeType(value="VkCoarseSampleLocationNV const *") VkCoarseSampleLocationNV.Buffer value) {
        VkCoarseSampleOrderCustomNV.npSampleLocations(this.address(), value);
        return this;
    }

    public VkCoarseSampleOrderCustomNV set(int shadingRate, int sampleCount, VkCoarseSampleLocationNV.Buffer pSampleLocations) {
        this.shadingRate(shadingRate);
        this.sampleCount(sampleCount);
        this.pSampleLocations(pSampleLocations);
        return this;
    }

    public VkCoarseSampleOrderCustomNV set(VkCoarseSampleOrderCustomNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCoarseSampleOrderCustomNV malloc() {
        return new VkCoarseSampleOrderCustomNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCoarseSampleOrderCustomNV calloc() {
        return new VkCoarseSampleOrderCustomNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCoarseSampleOrderCustomNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCoarseSampleOrderCustomNV(MemoryUtil.memAddress(container), container);
    }

    public static VkCoarseSampleOrderCustomNV create(long address) {
        return new VkCoarseSampleOrderCustomNV(address, null);
    }

    public static @Nullable VkCoarseSampleOrderCustomNV createSafe(long address) {
        return address == 0L ? null : new VkCoarseSampleOrderCustomNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCoarseSampleOrderCustomNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCoarseSampleOrderCustomNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkCoarseSampleOrderCustomNV mallocStack() {
        return VkCoarseSampleOrderCustomNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCoarseSampleOrderCustomNV callocStack() {
        return VkCoarseSampleOrderCustomNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkCoarseSampleOrderCustomNV mallocStack(MemoryStack stack) {
        return VkCoarseSampleOrderCustomNV.malloc(stack);
    }

    @Deprecated
    public static VkCoarseSampleOrderCustomNV callocStack(MemoryStack stack) {
        return VkCoarseSampleOrderCustomNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkCoarseSampleOrderCustomNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkCoarseSampleOrderCustomNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCoarseSampleOrderCustomNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCoarseSampleOrderCustomNV.calloc(capacity, stack);
    }

    public static VkCoarseSampleOrderCustomNV malloc(MemoryStack stack) {
        return new VkCoarseSampleOrderCustomNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCoarseSampleOrderCustomNV calloc(MemoryStack stack) {
        return new VkCoarseSampleOrderCustomNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nshadingRate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADINGRATE);
    }

    public static int nsampleCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLECOUNT);
    }

    public static int nsampleLocationCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLELOCATIONCOUNT);
    }

    public static VkCoarseSampleLocationNV.Buffer npSampleLocations(long struct) {
        return VkCoarseSampleLocationNV.create(MemoryUtil.memGetAddress(struct + (long)PSAMPLELOCATIONS), VkCoarseSampleOrderCustomNV.nsampleLocationCount(struct));
    }

    public static void nshadingRate(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADINGRATE, value);
    }

    public static void nsampleCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLECOUNT, value);
    }

    public static void nsampleLocationCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLELOCATIONCOUNT, value);
    }

    public static void npSampleLocations(long struct, VkCoarseSampleLocationNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSAMPLELOCATIONS, value.address());
        VkCoarseSampleOrderCustomNV.nsampleLocationCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSAMPLELOCATIONS));
    }

    static {
        Struct.Layout layout = VkCoarseSampleOrderCustomNV.__struct(VkCoarseSampleOrderCustomNV.__member(4), VkCoarseSampleOrderCustomNV.__member(4), VkCoarseSampleOrderCustomNV.__member(4), VkCoarseSampleOrderCustomNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SHADINGRATE = layout.offsetof(0);
        SAMPLECOUNT = layout.offsetof(1);
        SAMPLELOCATIONCOUNT = layout.offsetof(2);
        PSAMPLELOCATIONS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCoarseSampleOrderCustomNV, Buffer>
    implements NativeResource {
        private static final VkCoarseSampleOrderCustomNV ELEMENT_FACTORY = VkCoarseSampleOrderCustomNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkCoarseSampleOrderCustomNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkShadingRatePaletteEntryNV")
        public int shadingRate() {
            return VkCoarseSampleOrderCustomNV.nshadingRate(this.address());
        }

        @NativeType(value="uint32_t")
        public int sampleCount() {
            return VkCoarseSampleOrderCustomNV.nsampleCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int sampleLocationCount() {
            return VkCoarseSampleOrderCustomNV.nsampleLocationCount(this.address());
        }

        @NativeType(value="VkCoarseSampleLocationNV const *")
        public VkCoarseSampleLocationNV.Buffer pSampleLocations() {
            return VkCoarseSampleOrderCustomNV.npSampleLocations(this.address());
        }

        public Buffer shadingRate(@NativeType(value="VkShadingRatePaletteEntryNV") int value) {
            VkCoarseSampleOrderCustomNV.nshadingRate(this.address(), value);
            return this;
        }

        public Buffer sampleCount(@NativeType(value="uint32_t") int value) {
            VkCoarseSampleOrderCustomNV.nsampleCount(this.address(), value);
            return this;
        }

        public Buffer pSampleLocations(@NativeType(value="VkCoarseSampleLocationNV const *") VkCoarseSampleLocationNV.Buffer value) {
            VkCoarseSampleOrderCustomNV.npSampleLocations(this.address(), value);
            return this;
        }
    }
}

