/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCopyMemoryToImageInfo;
import org.lwjgl.vulkan.VkMemoryToImageCopy;

public class VkCopyMemoryToImageInfoEXT
extends VkCopyMemoryToImageInfo {
    protected VkCopyMemoryToImageInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyMemoryToImageInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMemoryToImageInfoEXT(address, container);
    }

    public VkCopyMemoryToImageInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkCopyMemoryToImageInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyMemoryToImageInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkCopyMemoryToImageInfoEXT sType$Default() {
        return this.sType(1000270005);
    }

    @Override
    public VkCopyMemoryToImageInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyMemoryToImageInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkCopyMemoryToImageInfoEXT flags(@NativeType(value="VkHostImageCopyFlags") int value) {
        VkCopyMemoryToImageInfoEXT.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkCopyMemoryToImageInfoEXT dstImage(@NativeType(value="VkImage") long value) {
        VkCopyMemoryToImageInfoEXT.ndstImage(this.address(), value);
        return this;
    }

    @Override
    public VkCopyMemoryToImageInfoEXT dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyMemoryToImageInfoEXT.ndstImageLayout(this.address(), value);
        return this;
    }

    @Override
    public VkCopyMemoryToImageInfoEXT pRegions(@NativeType(value="VkMemoryToImageCopy const *") VkMemoryToImageCopy.Buffer value) {
        VkCopyMemoryToImageInfoEXT.npRegions(this.address(), value);
        return this;
    }

    @Override
    public VkCopyMemoryToImageInfoEXT set(int sType, long pNext, int flags, long dstImage, int dstImageLayout, VkMemoryToImageCopy.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyMemoryToImageInfoEXT set(VkCopyMemoryToImageInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyMemoryToImageInfoEXT malloc() {
        return new VkCopyMemoryToImageInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfoEXT calloc() {
        return new VkCopyMemoryToImageInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyMemoryToImageInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyMemoryToImageInfoEXT create(long address) {
        return new VkCopyMemoryToImageInfoEXT(address, null);
    }

    public static @Nullable VkCopyMemoryToImageInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyMemoryToImageInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyMemoryToImageInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMemoryToImageInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMemoryToImageInfoEXT malloc(MemoryStack stack) {
        return new VkCopyMemoryToImageInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMemoryToImageInfoEXT calloc(MemoryStack stack) {
        return new VkCopyMemoryToImageInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkCopyMemoryToImageInfo.Buffer {
        private static final VkCopyMemoryToImageInfoEXT ELEMENT_FACTORY = VkCopyMemoryToImageInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkCopyMemoryToImageInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyMemoryToImageInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000270005);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyMemoryToImageInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkHostImageCopyFlags") int value) {
            VkCopyMemoryToImageInfoEXT.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyMemoryToImageInfoEXT.ndstImage(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyMemoryToImageInfoEXT.ndstImageLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer pRegions(@NativeType(value="VkMemoryToImageCopy const *") VkMemoryToImageCopy.Buffer value) {
            VkCopyMemoryToImageInfoEXT.npRegions(this.address(), value);
            return this;
        }
    }
}

