/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCuModuleTexturingModeCreateInfoNVX;

public class VkCuModuleCreateInfoNVX
extends Struct<VkCuModuleCreateInfoNVX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DATASIZE;
    public static final int PDATA;

    protected VkCuModuleCreateInfoNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCuModuleCreateInfoNVX create(long address, @Nullable ByteBuffer container) {
        return new VkCuModuleCreateInfoNVX(address, container);
    }

    public VkCuModuleCreateInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCuModuleCreateInfoNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCuModuleCreateInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCuModuleCreateInfoNVX.npNext(this.address());
    }

    @NativeType(value="size_t")
    public long dataSize() {
        return VkCuModuleCreateInfoNVX.ndataSize(this.address());
    }

    @NativeType(value="void const *")
    public @Nullable ByteBuffer pData() {
        return VkCuModuleCreateInfoNVX.npData(this.address());
    }

    public VkCuModuleCreateInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkCuModuleCreateInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkCuModuleCreateInfoNVX sType$Default() {
        return this.sType(1000029000);
    }

    public VkCuModuleCreateInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkCuModuleCreateInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkCuModuleCreateInfoNVX pNext(VkCuModuleTexturingModeCreateInfoNVX value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkCuModuleCreateInfoNVX pData(@NativeType(value="void const *") @Nullable ByteBuffer value) {
        VkCuModuleCreateInfoNVX.npData(this.address(), value);
        return this;
    }

    public VkCuModuleCreateInfoNVX set(int sType, long pNext, @Nullable ByteBuffer pData) {
        this.sType(sType);
        this.pNext(pNext);
        this.pData(pData);
        return this;
    }

    public VkCuModuleCreateInfoNVX set(VkCuModuleCreateInfoNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCuModuleCreateInfoNVX malloc() {
        return new VkCuModuleCreateInfoNVX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCuModuleCreateInfoNVX calloc() {
        return new VkCuModuleCreateInfoNVX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCuModuleCreateInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCuModuleCreateInfoNVX(MemoryUtil.memAddress(container), container);
    }

    public static VkCuModuleCreateInfoNVX create(long address) {
        return new VkCuModuleCreateInfoNVX(address, null);
    }

    public static @Nullable VkCuModuleCreateInfoNVX createSafe(long address) {
        return address == 0L ? null : new VkCuModuleCreateInfoNVX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCuModuleCreateInfoNVX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCuModuleCreateInfoNVX.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCuModuleCreateInfoNVX malloc(MemoryStack stack) {
        return new VkCuModuleCreateInfoNVX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCuModuleCreateInfoNVX calloc(MemoryStack stack) {
        return new VkCuModuleCreateInfoNVX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ndataSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATASIZE);
    }

    public static @Nullable ByteBuffer npData(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDATA), (int)VkCuModuleCreateInfoNVX.ndataSize(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndataSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DATASIZE, value);
    }

    public static void npData(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddressSafe(value));
        VkCuModuleCreateInfoNVX.ndataSize(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkCuModuleCreateInfoNVX.ndataSize(struct) != 0L) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDATA));
        }
    }

    static {
        Struct.Layout layout = VkCuModuleCreateInfoNVX.__struct(VkCuModuleCreateInfoNVX.__member(4), VkCuModuleCreateInfoNVX.__member(POINTER_SIZE), VkCuModuleCreateInfoNVX.__member(POINTER_SIZE), VkCuModuleCreateInfoNVX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DATASIZE = layout.offsetof(2);
        PDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCuModuleCreateInfoNVX, Buffer>
    implements NativeResource {
        private static final VkCuModuleCreateInfoNVX ELEMENT_FACTORY = VkCuModuleCreateInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkCuModuleCreateInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCuModuleCreateInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCuModuleCreateInfoNVX.npNext(this.address());
        }

        @NativeType(value="size_t")
        public long dataSize() {
            return VkCuModuleCreateInfoNVX.ndataSize(this.address());
        }

        @NativeType(value="void const *")
        public @Nullable ByteBuffer pData() {
            return VkCuModuleCreateInfoNVX.npData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCuModuleCreateInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000029000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCuModuleCreateInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkCuModuleTexturingModeCreateInfoNVX value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pData(@NativeType(value="void const *") @Nullable ByteBuffer value) {
            VkCuModuleCreateInfoNVX.npData(this.address(), value);
            return this;
        }
    }
}

