/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferMemoryBarrier2;
import org.lwjgl.vulkan.VkDependencyInfo;

public class VkDependencyInfoKHR
extends VkDependencyInfo {
    protected VkDependencyInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDependencyInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDependencyInfoKHR(address, container);
    }

    public VkDependencyInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkDependencyInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDependencyInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR sType$Default() {
        return this.sType(1000314003);
    }

    @Override
    public VkDependencyInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDependencyInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
        VkDependencyInfoKHR.ndependencyFlags(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR pMemoryBarriers(@NativeType(value="VkMemoryBarrier2 const *")  @Nullable VkMemoryBarrier2.Buffer value) {
        VkDependencyInfoKHR.npMemoryBarriers(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR pBufferMemoryBarriers(@NativeType(value="VkBufferMemoryBarrier2 const *") @Nullable VkBufferMemoryBarrier2.Buffer value) {
        VkDependencyInfoKHR.npBufferMemoryBarriers(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR pImageMemoryBarriers(@NativeType(value="VkImageMemoryBarrier2 const *")  @Nullable VkImageMemoryBarrier2.Buffer value) {
        VkDependencyInfoKHR.npImageMemoryBarriers(this.address(), value);
        return this;
    }

    @Override
    public VkDependencyInfoKHR set(int sType, long pNext, int dependencyFlags,  @Nullable VkMemoryBarrier2.Buffer pMemoryBarriers, @Nullable VkBufferMemoryBarrier2.Buffer pBufferMemoryBarriers,  @Nullable VkImageMemoryBarrier2.Buffer pImageMemoryBarriers) {
        this.sType(sType);
        this.pNext(pNext);
        this.dependencyFlags(dependencyFlags);
        this.pMemoryBarriers(pMemoryBarriers);
        this.pBufferMemoryBarriers(pBufferMemoryBarriers);
        this.pImageMemoryBarriers(pImageMemoryBarriers);
        return this;
    }

    public VkDependencyInfoKHR set(VkDependencyInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDependencyInfoKHR malloc() {
        return new VkDependencyInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDependencyInfoKHR calloc() {
        return new VkDependencyInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDependencyInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDependencyInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkDependencyInfoKHR create(long address) {
        return new VkDependencyInfoKHR(address, null);
    }

    public static @Nullable VkDependencyInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkDependencyInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDependencyInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDependencyInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDependencyInfoKHR malloc(MemoryStack stack) {
        return new VkDependencyInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDependencyInfoKHR calloc(MemoryStack stack) {
        return new VkDependencyInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDependencyInfo.Buffer {
        private static final VkDependencyInfoKHR ELEMENT_FACTORY = VkDependencyInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDependencyInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDependencyInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000314003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDependencyInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer dependencyFlags(@NativeType(value="VkDependencyFlags") int value) {
            VkDependencyInfoKHR.ndependencyFlags(this.address(), value);
            return this;
        }

        @Override
        public Buffer pMemoryBarriers(@NativeType(value="VkMemoryBarrier2 const *")  @Nullable VkMemoryBarrier2.Buffer value) {
            VkDependencyInfoKHR.npMemoryBarriers(this.address(), value);
            return this;
        }

        @Override
        public Buffer pBufferMemoryBarriers(@NativeType(value="VkBufferMemoryBarrier2 const *") @Nullable VkBufferMemoryBarrier2.Buffer value) {
            VkDependencyInfoKHR.npBufferMemoryBarriers(this.address(), value);
            return this;
        }

        @Override
        public Buffer pImageMemoryBarriers(@NativeType(value="VkImageMemoryBarrier2 const *")  @Nullable VkImageMemoryBarrier2.Buffer value) {
            VkDependencyInfoKHR.npImageMemoryBarriers(this.address(), value);
            return this;
        }
    }
}

