/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorDataEXT;

public class VkDescriptorGetInfoEXT
extends Struct<VkDescriptorGetInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TYPE;
    public static final int DATA;

    protected VkDescriptorGetInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDescriptorGetInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorGetInfoEXT(address, container);
    }

    public VkDescriptorGetInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorGetInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorGetInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorGetInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int type() {
        return VkDescriptorGetInfoEXT.ntype(this.address());
    }

    public VkDescriptorDataEXT data() {
        return VkDescriptorGetInfoEXT.ndata(this.address());
    }

    public VkDescriptorGetInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorGetInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT sType$Default() {
        return this.sType(1000316004);
    }

    public VkDescriptorGetInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDescriptorGetInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT type(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorGetInfoEXT.ntype(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT data(VkDescriptorDataEXT value) {
        VkDescriptorGetInfoEXT.ndata(this.address(), value);
        return this;
    }

    public VkDescriptorGetInfoEXT data(Consumer<VkDescriptorDataEXT> consumer) {
        consumer.accept(this.data());
        return this;
    }

    public VkDescriptorGetInfoEXT set(int sType, long pNext, int type, VkDescriptorDataEXT data) {
        this.sType(sType);
        this.pNext(pNext);
        this.type(type);
        this.data(data);
        return this;
    }

    public VkDescriptorGetInfoEXT set(VkDescriptorGetInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorGetInfoEXT malloc() {
        return new VkDescriptorGetInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDescriptorGetInfoEXT calloc() {
        return new VkDescriptorGetInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDescriptorGetInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDescriptorGetInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorGetInfoEXT create(long address) {
        return new VkDescriptorGetInfoEXT(address, null);
    }

    public static @Nullable VkDescriptorGetInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkDescriptorGetInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDescriptorGetInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorGetInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDescriptorGetInfoEXT malloc(MemoryStack stack) {
        return new VkDescriptorGetInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorGetInfoEXT calloc(MemoryStack stack) {
        return new VkDescriptorGetInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static VkDescriptorDataEXT ndata(long struct) {
        return VkDescriptorDataEXT.create(struct + (long)DATA);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void ndata(long struct, VkDescriptorDataEXT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DATA, VkDescriptorDataEXT.SIZEOF);
    }

    static {
        Struct.Layout layout = VkDescriptorGetInfoEXT.__struct(VkDescriptorGetInfoEXT.__member(4), VkDescriptorGetInfoEXT.__member(POINTER_SIZE), VkDescriptorGetInfoEXT.__member(4), VkDescriptorGetInfoEXT.__member(VkDescriptorDataEXT.SIZEOF, VkDescriptorDataEXT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        DATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorGetInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDescriptorGetInfoEXT ELEMENT_FACTORY = VkDescriptorGetInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDescriptorGetInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorGetInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorGetInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int type() {
            return VkDescriptorGetInfoEXT.ntype(this.address());
        }

        public VkDescriptorDataEXT data() {
            return VkDescriptorGetInfoEXT.ndata(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorGetInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000316004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorGetInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorGetInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer data(VkDescriptorDataEXT value) {
            VkDescriptorGetInfoEXT.ndata(this.address(), value);
            return this;
        }

        public Buffer data(Consumer<VkDescriptorDataEXT> consumer) {
            consumer.accept(this.data());
            return this;
        }
    }
}

