/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorSetVariableDescriptorCountAllocateInfo;
import org.lwjgl.vulkan.VkDescriptorSetVariableDescriptorCountAllocateInfoEXT;

public class VkDescriptorSetAllocateInfo
extends Struct<VkDescriptorSetAllocateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DESCRIPTORPOOL;
    public static final int DESCRIPTORSETCOUNT;
    public static final int PSETLAYOUTS;

    protected VkDescriptorSetAllocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDescriptorSetAllocateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorSetAllocateInfo(address, container);
    }

    public VkDescriptorSetAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorSetAllocateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorSetAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkDescriptorPool")
    public long descriptorPool() {
        return VkDescriptorSetAllocateInfo.ndescriptorPool(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorSetCount() {
        return VkDescriptorSetAllocateInfo.ndescriptorSetCount(this.address());
    }

    @NativeType(value="VkDescriptorSetLayout const *")
    public LongBuffer pSetLayouts() {
        return VkDescriptorSetAllocateInfo.npSetLayouts(this.address());
    }

    public VkDescriptorSetAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo sType$Default() {
        return this.sType(34);
    }

    public VkDescriptorSetAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkDescriptorSetAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo pNext(VkDescriptorSetVariableDescriptorCountAllocateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetAllocateInfo pNext(VkDescriptorSetVariableDescriptorCountAllocateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetAllocateInfo descriptorPool(@NativeType(value="VkDescriptorPool") long value) {
        VkDescriptorSetAllocateInfo.ndescriptorPool(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo pSetLayouts(@NativeType(value="VkDescriptorSetLayout const *") LongBuffer value) {
        VkDescriptorSetAllocateInfo.npSetLayouts(this.address(), value);
        return this;
    }

    public VkDescriptorSetAllocateInfo set(int sType, long pNext, long descriptorPool, LongBuffer pSetLayouts) {
        this.sType(sType);
        this.pNext(pNext);
        this.descriptorPool(descriptorPool);
        this.pSetLayouts(pSetLayouts);
        return this;
    }

    public VkDescriptorSetAllocateInfo set(VkDescriptorSetAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetAllocateInfo malloc() {
        return new VkDescriptorSetAllocateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDescriptorSetAllocateInfo calloc() {
        return new VkDescriptorSetAllocateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDescriptorSetAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDescriptorSetAllocateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorSetAllocateInfo create(long address) {
        return new VkDescriptorSetAllocateInfo(address, null);
    }

    public static @Nullable VkDescriptorSetAllocateInfo createSafe(long address) {
        return address == 0L ? null : new VkDescriptorSetAllocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDescriptorSetAllocateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorSetAllocateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorSetAllocateInfo mallocStack() {
        return VkDescriptorSetAllocateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetAllocateInfo callocStack() {
        return VkDescriptorSetAllocateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetAllocateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorSetAllocateInfo callocStack(MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetAllocateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetAllocateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetAllocateInfo.calloc(capacity, stack);
    }

    public static VkDescriptorSetAllocateInfo malloc(MemoryStack stack) {
        return new VkDescriptorSetAllocateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorSetAllocateInfo calloc(MemoryStack stack) {
        return new VkDescriptorSetAllocateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ndescriptorPool(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DESCRIPTORPOOL);
    }

    public static int ndescriptorSetCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORSETCOUNT);
    }

    public static LongBuffer npSetLayouts(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTS), VkDescriptorSetAllocateInfo.ndescriptorSetCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndescriptorPool(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DESCRIPTORPOOL, value);
    }

    public static void ndescriptorSetCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORSETCOUNT, value);
    }

    public static void npSetLayouts(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSETLAYOUTS, MemoryUtil.memAddress(value));
        VkDescriptorSetAllocateInfo.ndescriptorSetCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTS));
    }

    static {
        Struct.Layout layout = VkDescriptorSetAllocateInfo.__struct(VkDescriptorSetAllocateInfo.__member(4), VkDescriptorSetAllocateInfo.__member(POINTER_SIZE), VkDescriptorSetAllocateInfo.__member(8), VkDescriptorSetAllocateInfo.__member(4), VkDescriptorSetAllocateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DESCRIPTORPOOL = layout.offsetof(2);
        DESCRIPTORSETCOUNT = layout.offsetof(3);
        PSETLAYOUTS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorSetAllocateInfo ELEMENT_FACTORY = VkDescriptorSetAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDescriptorSetAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorSetAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkDescriptorPool")
        public long descriptorPool() {
            return VkDescriptorSetAllocateInfo.ndescriptorPool(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorSetCount() {
            return VkDescriptorSetAllocateInfo.ndescriptorSetCount(this.address());
        }

        @NativeType(value="VkDescriptorSetLayout const *")
        public LongBuffer pSetLayouts() {
            return VkDescriptorSetAllocateInfo.npSetLayouts(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(34);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorSetAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDescriptorSetVariableDescriptorCountAllocateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDescriptorSetVariableDescriptorCountAllocateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer descriptorPool(@NativeType(value="VkDescriptorPool") long value) {
            VkDescriptorSetAllocateInfo.ndescriptorPool(this.address(), value);
            return this;
        }

        public Buffer pSetLayouts(@NativeType(value="VkDescriptorSetLayout const *") LongBuffer value) {
            VkDescriptorSetAllocateInfo.npSetLayouts(this.address(), value);
            return this;
        }
    }
}

