/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceAddressBindingCallbackDataEXT
extends Struct<VkDeviceAddressBindingCallbackDataEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int BASEADDRESS;
    public static final int SIZE;
    public static final int BINDINGTYPE;

    protected VkDeviceAddressBindingCallbackDataEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceAddressBindingCallbackDataEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceAddressBindingCallbackDataEXT(address, container);
    }

    public VkDeviceAddressBindingCallbackDataEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceAddressBindingCallbackDataEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceAddressBindingCallbackDataEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDeviceAddressBindingCallbackDataEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceAddressBindingFlagsEXT")
    public int flags() {
        return VkDeviceAddressBindingCallbackDataEXT.nflags(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long baseAddress() {
        return VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkDeviceAddressBindingCallbackDataEXT.nsize(this.address());
    }

    @NativeType(value="VkDeviceAddressBindingTypeEXT")
    public int bindingType() {
        return VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address());
    }

    public VkDeviceAddressBindingCallbackDataEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceAddressBindingCallbackDataEXT.nsType(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT sType$Default() {
        return this.sType(1000354001);
    }

    public VkDeviceAddressBindingCallbackDataEXT pNext(@NativeType(value="void *") long value) {
        VkDeviceAddressBindingCallbackDataEXT.npNext(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT flags(@NativeType(value="VkDeviceAddressBindingFlagsEXT") int value) {
        VkDeviceAddressBindingCallbackDataEXT.nflags(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT baseAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT size(@NativeType(value="VkDeviceSize") long value) {
        VkDeviceAddressBindingCallbackDataEXT.nsize(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT bindingType(@NativeType(value="VkDeviceAddressBindingTypeEXT") int value) {
        VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address(), value);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT set(int sType, long pNext, int flags, long baseAddress, long size, int bindingType) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.baseAddress(baseAddress);
        this.size(size);
        this.bindingType(bindingType);
        return this;
    }

    public VkDeviceAddressBindingCallbackDataEXT set(VkDeviceAddressBindingCallbackDataEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceAddressBindingCallbackDataEXT malloc() {
        return new VkDeviceAddressBindingCallbackDataEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceAddressBindingCallbackDataEXT calloc() {
        return new VkDeviceAddressBindingCallbackDataEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceAddressBindingCallbackDataEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceAddressBindingCallbackDataEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceAddressBindingCallbackDataEXT create(long address) {
        return new VkDeviceAddressBindingCallbackDataEXT(address, null);
    }

    public static @Nullable VkDeviceAddressBindingCallbackDataEXT createSafe(long address) {
        return address == 0L ? null : new VkDeviceAddressBindingCallbackDataEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceAddressBindingCallbackDataEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceAddressBindingCallbackDataEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceAddressBindingCallbackDataEXT malloc(MemoryStack stack) {
        return new VkDeviceAddressBindingCallbackDataEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceAddressBindingCallbackDataEXT calloc(MemoryStack stack) {
        return new VkDeviceAddressBindingCallbackDataEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nbaseAddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BASEADDRESS);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static int nbindingType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDINGTYPE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nbaseAddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BASEADDRESS, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    public static void nbindingType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDINGTYPE, value);
    }

    static {
        Struct.Layout layout = VkDeviceAddressBindingCallbackDataEXT.__struct(VkDeviceAddressBindingCallbackDataEXT.__member(4), VkDeviceAddressBindingCallbackDataEXT.__member(POINTER_SIZE), VkDeviceAddressBindingCallbackDataEXT.__member(4), VkDeviceAddressBindingCallbackDataEXT.__member(8), VkDeviceAddressBindingCallbackDataEXT.__member(8), VkDeviceAddressBindingCallbackDataEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        BASEADDRESS = layout.offsetof(3);
        SIZE = layout.offsetof(4);
        BINDINGTYPE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceAddressBindingCallbackDataEXT, Buffer>
    implements NativeResource {
        private static final VkDeviceAddressBindingCallbackDataEXT ELEMENT_FACTORY = VkDeviceAddressBindingCallbackDataEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDeviceAddressBindingCallbackDataEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceAddressBindingCallbackDataEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDeviceAddressBindingCallbackDataEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceAddressBindingFlagsEXT")
        public int flags() {
            return VkDeviceAddressBindingCallbackDataEXT.nflags(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long baseAddress() {
            return VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkDeviceAddressBindingCallbackDataEXT.nsize(this.address());
        }

        @NativeType(value="VkDeviceAddressBindingTypeEXT")
        public int bindingType() {
            return VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceAddressBindingCallbackDataEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000354001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDeviceAddressBindingCallbackDataEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDeviceAddressBindingFlagsEXT") int value) {
            VkDeviceAddressBindingCallbackDataEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer baseAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceAddressBindingCallbackDataEXT.nbaseAddress(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkDeviceAddressBindingCallbackDataEXT.nsize(this.address(), value);
            return this;
        }

        public Buffer bindingType(@NativeType(value="VkDeviceAddressBindingTypeEXT") int value) {
            VkDeviceAddressBindingCallbackDataEXT.nbindingType(this.address(), value);
            return this;
        }
    }
}

