/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferCreateInfo;
import org.lwjgl.vulkan.VkDeviceBufferMemoryRequirements;

public class VkDeviceBufferMemoryRequirementsKHR
extends VkDeviceBufferMemoryRequirements {
    protected VkDeviceBufferMemoryRequirementsKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceBufferMemoryRequirementsKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceBufferMemoryRequirementsKHR(address, container);
    }

    public VkDeviceBufferMemoryRequirementsKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceBufferMemoryRequirementsKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR sType$Default() {
        return this.sType(1000413002);
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceBufferMemoryRequirementsKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR pCreateInfo(@NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo value) {
        VkDeviceBufferMemoryRequirementsKHR.npCreateInfo(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceBufferMemoryRequirementsKHR set(int sType, long pNext, VkBufferCreateInfo pCreateInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        return this;
    }

    public VkDeviceBufferMemoryRequirementsKHR set(VkDeviceBufferMemoryRequirementsKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceBufferMemoryRequirementsKHR malloc() {
        return new VkDeviceBufferMemoryRequirementsKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceBufferMemoryRequirementsKHR calloc() {
        return new VkDeviceBufferMemoryRequirementsKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceBufferMemoryRequirementsKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceBufferMemoryRequirementsKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceBufferMemoryRequirementsKHR create(long address) {
        return new VkDeviceBufferMemoryRequirementsKHR(address, null);
    }

    public static @Nullable VkDeviceBufferMemoryRequirementsKHR createSafe(long address) {
        return address == 0L ? null : new VkDeviceBufferMemoryRequirementsKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceBufferMemoryRequirementsKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceBufferMemoryRequirementsKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceBufferMemoryRequirementsKHR malloc(MemoryStack stack) {
        return new VkDeviceBufferMemoryRequirementsKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceBufferMemoryRequirementsKHR calloc(MemoryStack stack) {
        return new VkDeviceBufferMemoryRequirementsKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDeviceBufferMemoryRequirements.Buffer {
        private static final VkDeviceBufferMemoryRequirementsKHR ELEMENT_FACTORY = VkDeviceBufferMemoryRequirementsKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDeviceBufferMemoryRequirementsKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceBufferMemoryRequirementsKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000413002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceBufferMemoryRequirementsKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pCreateInfo(@NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo value) {
            VkDeviceBufferMemoryRequirementsKHR.npCreateInfo(this.address(), value);
            return this;
        }
    }
}

