/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDeviceGroupBindSparseInfo;

public class VkDeviceGroupBindSparseInfoKHR
extends VkDeviceGroupBindSparseInfo {
    protected VkDeviceGroupBindSparseInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceGroupBindSparseInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceGroupBindSparseInfoKHR(address, container);
    }

    public VkDeviceGroupBindSparseInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupBindSparseInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR sType$Default() {
        return this.sType(1000060006);
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupBindSparseInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfoKHR.nresourceDeviceIndex(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfoKHR.nmemoryDeviceIndex(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR set(int sType, long pNext, int resourceDeviceIndex, int memoryDeviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.resourceDeviceIndex(resourceDeviceIndex);
        this.memoryDeviceIndex(memoryDeviceIndex);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHR set(VkDeviceGroupBindSparseInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupBindSparseInfoKHR malloc() {
        return new VkDeviceGroupBindSparseInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfoKHR calloc() {
        return new VkDeviceGroupBindSparseInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceGroupBindSparseInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceGroupBindSparseInfoKHR create(long address) {
        return new VkDeviceGroupBindSparseInfoKHR(address, null);
    }

    public static @Nullable VkDeviceGroupBindSparseInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkDeviceGroupBindSparseInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceGroupBindSparseInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupBindSparseInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfoKHR mallocStack() {
        return VkDeviceGroupBindSparseInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfoKHR callocStack() {
        return VkDeviceGroupBindSparseInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfoKHR mallocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkDeviceGroupBindSparseInfoKHR callocStack(MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupBindSparseInfoKHR.calloc(capacity, stack);
    }

    public static VkDeviceGroupBindSparseInfoKHR malloc(MemoryStack stack) {
        return new VkDeviceGroupBindSparseInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceGroupBindSparseInfoKHR calloc(MemoryStack stack) {
        return new VkDeviceGroupBindSparseInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDeviceGroupBindSparseInfo.Buffer {
        private static final VkDeviceGroupBindSparseInfoKHR ELEMENT_FACTORY = VkDeviceGroupBindSparseInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDeviceGroupBindSparseInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupBindSparseInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000060006);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupBindSparseInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfoKHR.nresourceDeviceIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfoKHR.nmemoryDeviceIndex(this.address(), value);
            return this;
        }
    }
}

