/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupDeviceCreateInfo
extends Struct<VkDeviceGroupDeviceCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHYSICALDEVICECOUNT;
    public static final int PPHYSICALDEVICES;

    protected VkDeviceGroupDeviceCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceGroupDeviceCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceGroupDeviceCreateInfo(address, container);
    }

    public VkDeviceGroupDeviceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceGroupDeviceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupDeviceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupDeviceCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int physicalDeviceCount() {
        return VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(this.address());
    }

    @NativeType(value="VkPhysicalDevice const *")
    public @Nullable PointerBuffer pPhysicalDevices() {
        return VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address());
    }

    public VkDeviceGroupDeviceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupDeviceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo sType$Default() {
        return this.sType(1000070001);
    }

    public VkDeviceGroupDeviceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupDeviceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo pPhysicalDevices(@NativeType(value="VkPhysicalDevice const *") @Nullable PointerBuffer value) {
        VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo set(int sType, long pNext, @Nullable PointerBuffer pPhysicalDevices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pPhysicalDevices(pPhysicalDevices);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo set(VkDeviceGroupDeviceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceGroupDeviceCreateInfo malloc() {
        return new VkDeviceGroupDeviceCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceGroupDeviceCreateInfo calloc() {
        return new VkDeviceGroupDeviceCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceGroupDeviceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceGroupDeviceCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceGroupDeviceCreateInfo create(long address) {
        return new VkDeviceGroupDeviceCreateInfo(address, null);
    }

    public static @Nullable VkDeviceGroupDeviceCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceGroupDeviceCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceGroupDeviceCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupDeviceCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDeviceGroupDeviceCreateInfo mallocStack() {
        return VkDeviceGroupDeviceCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupDeviceCreateInfo callocStack() {
        return VkDeviceGroupDeviceCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDeviceGroupDeviceCreateInfo mallocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkDeviceGroupDeviceCreateInfo callocStack(MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDeviceGroupDeviceCreateInfo.calloc(capacity, stack);
    }

    public static VkDeviceGroupDeviceCreateInfo malloc(MemoryStack stack) {
        return new VkDeviceGroupDeviceCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceGroupDeviceCreateInfo calloc(MemoryStack stack) {
        return new VkDeviceGroupDeviceCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nphysicalDeviceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PHYSICALDEVICECOUNT);
    }

    public static @Nullable PointerBuffer npPhysicalDevices(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPHYSICALDEVICES), VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nphysicalDeviceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PHYSICALDEVICECOUNT, value);
    }

    public static void npPhysicalDevices(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPHYSICALDEVICES, MemoryUtil.memAddressSafe(value));
        VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPHYSICALDEVICES));
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupDeviceCreateInfo.__struct(VkDeviceGroupDeviceCreateInfo.__member(4), VkDeviceGroupDeviceCreateInfo.__member(POINTER_SIZE), VkDeviceGroupDeviceCreateInfo.__member(4), VkDeviceGroupDeviceCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHYSICALDEVICECOUNT = layout.offsetof(2);
        PPHYSICALDEVICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupDeviceCreateInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupDeviceCreateInfo ELEMENT_FACTORY = VkDeviceGroupDeviceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDeviceGroupDeviceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupDeviceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupDeviceCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int physicalDeviceCount() {
            return VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(this.address());
        }

        @NativeType(value="VkPhysicalDevice const *")
        public @Nullable PointerBuffer pPhysicalDevices() {
            return VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupDeviceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000070001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupDeviceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pPhysicalDevices(@NativeType(value="VkPhysicalDevice const *") @Nullable PointerBuffer value) {
            VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address(), value);
            return this;
        }
    }
}

