/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceOrHostAddressConstAMDX
extends Struct<VkDeviceOrHostAddressConstAMDX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEVICEADDRESS;
    public static final int HOSTADDRESS;

    protected VkDeviceOrHostAddressConstAMDX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceOrHostAddressConstAMDX create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceOrHostAddressConstAMDX(address, container);
    }

    public VkDeviceOrHostAddressConstAMDX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceOrHostAddressConstAMDX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkDeviceOrHostAddressConstAMDX.ndeviceAddress(this.address());
    }

    @NativeType(value="void const *")
    public long hostAddress() {
        return VkDeviceOrHostAddressConstAMDX.nhostAddress(this.address());
    }

    public VkDeviceOrHostAddressConstAMDX deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceOrHostAddressConstAMDX.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressConstAMDX hostAddress(@NativeType(value="void const *") long value) {
        VkDeviceOrHostAddressConstAMDX.nhostAddress(this.address(), value);
        return this;
    }

    public VkDeviceOrHostAddressConstAMDX set(VkDeviceOrHostAddressConstAMDX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceOrHostAddressConstAMDX malloc() {
        return new VkDeviceOrHostAddressConstAMDX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceOrHostAddressConstAMDX calloc() {
        return new VkDeviceOrHostAddressConstAMDX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceOrHostAddressConstAMDX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceOrHostAddressConstAMDX(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceOrHostAddressConstAMDX create(long address) {
        return new VkDeviceOrHostAddressConstAMDX(address, null);
    }

    public static @Nullable VkDeviceOrHostAddressConstAMDX createSafe(long address) {
        return address == 0L ? null : new VkDeviceOrHostAddressConstAMDX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceOrHostAddressConstAMDX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceOrHostAddressConstAMDX.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceOrHostAddressConstAMDX malloc(MemoryStack stack) {
        return new VkDeviceOrHostAddressConstAMDX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceOrHostAddressConstAMDX calloc(MemoryStack stack) {
        return new VkDeviceOrHostAddressConstAMDX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndeviceAddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DEVICEADDRESS);
    }

    public static long nhostAddress(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HOSTADDRESS);
    }

    public static void ndeviceAddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DEVICEADDRESS, value);
    }

    public static void nhostAddress(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HOSTADDRESS, value);
    }

    static {
        Struct.Layout layout = VkDeviceOrHostAddressConstAMDX.__union(VkDeviceOrHostAddressConstAMDX.__member(8), VkDeviceOrHostAddressConstAMDX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEVICEADDRESS = layout.offsetof(0);
        HOSTADDRESS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceOrHostAddressConstAMDX, Buffer>
    implements NativeResource {
        private static final VkDeviceOrHostAddressConstAMDX ELEMENT_FACTORY = VkDeviceOrHostAddressConstAMDX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDeviceOrHostAddressConstAMDX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkDeviceOrHostAddressConstAMDX.ndeviceAddress(this.address());
        }

        @NativeType(value="void const *")
        public long hostAddress() {
            return VkDeviceOrHostAddressConstAMDX.nhostAddress(this.address());
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceOrHostAddressConstAMDX.ndeviceAddress(this.address(), value);
            return this;
        }

        public Buffer hostAddress(@NativeType(value="void const *") long value) {
            VkDeviceOrHostAddressConstAMDX.nhostAddress(this.address(), value);
            return this;
        }
    }
}

