/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkDisplayPresentInfoKHR
extends Struct<VkDisplayPresentInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCRECT;
    public static final int DSTRECT;
    public static final int PERSISTENT;

    protected VkDisplayPresentInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDisplayPresentInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDisplayPresentInfoKHR(address, container);
    }

    public VkDisplayPresentInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDisplayPresentInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDisplayPresentInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDisplayPresentInfoKHR.npNext(this.address());
    }

    public VkRect2D srcRect() {
        return VkDisplayPresentInfoKHR.nsrcRect(this.address());
    }

    public VkRect2D dstRect() {
        return VkDisplayPresentInfoKHR.ndstRect(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean persistent() {
        return VkDisplayPresentInfoKHR.npersistent(this.address()) != 0;
    }

    public VkDisplayPresentInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDisplayPresentInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR sType$Default() {
        return this.sType(1000003000);
    }

    public VkDisplayPresentInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDisplayPresentInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR srcRect(VkRect2D value) {
        VkDisplayPresentInfoKHR.nsrcRect(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR srcRect(Consumer<VkRect2D> consumer) {
        consumer.accept(this.srcRect());
        return this;
    }

    public VkDisplayPresentInfoKHR dstRect(VkRect2D value) {
        VkDisplayPresentInfoKHR.ndstRect(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR dstRect(Consumer<VkRect2D> consumer) {
        consumer.accept(this.dstRect());
        return this;
    }

    public VkDisplayPresentInfoKHR persistent(@NativeType(value="VkBool32") boolean value) {
        VkDisplayPresentInfoKHR.npersistent(this.address(), value ? 1 : 0);
        return this;
    }

    public VkDisplayPresentInfoKHR set(int sType, long pNext, VkRect2D srcRect, VkRect2D dstRect, boolean persistent) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcRect(srcRect);
        this.dstRect(dstRect);
        this.persistent(persistent);
        return this;
    }

    public VkDisplayPresentInfoKHR set(VkDisplayPresentInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDisplayPresentInfoKHR malloc() {
        return new VkDisplayPresentInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDisplayPresentInfoKHR calloc() {
        return new VkDisplayPresentInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDisplayPresentInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDisplayPresentInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkDisplayPresentInfoKHR create(long address) {
        return new VkDisplayPresentInfoKHR(address, null);
    }

    public static @Nullable VkDisplayPresentInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkDisplayPresentInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDisplayPresentInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayPresentInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDisplayPresentInfoKHR mallocStack() {
        return VkDisplayPresentInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPresentInfoKHR callocStack() {
        return VkDisplayPresentInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPresentInfoKHR mallocStack(MemoryStack stack) {
        return VkDisplayPresentInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayPresentInfoKHR callocStack(MemoryStack stack) {
        return VkDisplayPresentInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayPresentInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayPresentInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPresentInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPresentInfoKHR.calloc(capacity, stack);
    }

    public static VkDisplayPresentInfoKHR malloc(MemoryStack stack) {
        return new VkDisplayPresentInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDisplayPresentInfoKHR calloc(MemoryStack stack) {
        return new VkDisplayPresentInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkRect2D nsrcRect(long struct) {
        return VkRect2D.create(struct + (long)SRCRECT);
    }

    public static VkRect2D ndstRect(long struct) {
        return VkRect2D.create(struct + (long)DSTRECT);
    }

    public static int npersistent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PERSISTENT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcRect(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCRECT, VkRect2D.SIZEOF);
    }

    public static void ndstRect(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTRECT, VkRect2D.SIZEOF);
    }

    public static void npersistent(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PERSISTENT, value);
    }

    static {
        Struct.Layout layout = VkDisplayPresentInfoKHR.__struct(VkDisplayPresentInfoKHR.__member(4), VkDisplayPresentInfoKHR.__member(POINTER_SIZE), VkDisplayPresentInfoKHR.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkDisplayPresentInfoKHR.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkDisplayPresentInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCRECT = layout.offsetof(2);
        DSTRECT = layout.offsetof(3);
        PERSISTENT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayPresentInfoKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayPresentInfoKHR ELEMENT_FACTORY = VkDisplayPresentInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDisplayPresentInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDisplayPresentInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDisplayPresentInfoKHR.npNext(this.address());
        }

        public VkRect2D srcRect() {
            return VkDisplayPresentInfoKHR.nsrcRect(this.address());
        }

        public VkRect2D dstRect() {
            return VkDisplayPresentInfoKHR.ndstRect(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean persistent() {
            return VkDisplayPresentInfoKHR.npersistent(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDisplayPresentInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000003000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDisplayPresentInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer srcRect(VkRect2D value) {
            VkDisplayPresentInfoKHR.nsrcRect(this.address(), value);
            return this;
        }

        public Buffer srcRect(Consumer<VkRect2D> consumer) {
            consumer.accept(this.srcRect());
            return this;
        }

        public Buffer dstRect(VkRect2D value) {
            VkDisplayPresentInfoKHR.ndstRect(this.address(), value);
            return this;
        }

        public Buffer dstRect(Consumer<VkRect2D> consumer) {
            consumer.accept(this.dstRect());
            return this;
        }

        public Buffer persistent(@NativeType(value="VkBool32") boolean value) {
            VkDisplayPresentInfoKHR.npersistent(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

