/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDrawIndirectCommand
extends Struct<VkDrawIndirectCommand>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEXCOUNT;
    public static final int INSTANCECOUNT;
    public static final int FIRSTVERTEX;
    public static final int FIRSTINSTANCE;

    protected VkDrawIndirectCommand(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDrawIndirectCommand create(long address, @Nullable ByteBuffer container) {
        return new VkDrawIndirectCommand(address, container);
    }

    public VkDrawIndirectCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDrawIndirectCommand.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return VkDrawIndirectCommand.nvertexCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int instanceCount() {
        return VkDrawIndirectCommand.ninstanceCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstVertex() {
        return VkDrawIndirectCommand.nfirstVertex(this.address());
    }

    @NativeType(value="uint32_t")
    public int firstInstance() {
        return VkDrawIndirectCommand.nfirstInstance(this.address());
    }

    public VkDrawIndirectCommand vertexCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.nvertexCount(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand instanceCount(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.ninstanceCount(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand firstVertex(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.nfirstVertex(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand firstInstance(@NativeType(value="uint32_t") int value) {
        VkDrawIndirectCommand.nfirstInstance(this.address(), value);
        return this;
    }

    public VkDrawIndirectCommand set(int vertexCount, int instanceCount, int firstVertex, int firstInstance) {
        this.vertexCount(vertexCount);
        this.instanceCount(instanceCount);
        this.firstVertex(firstVertex);
        this.firstInstance(firstInstance);
        return this;
    }

    public VkDrawIndirectCommand set(VkDrawIndirectCommand src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDrawIndirectCommand malloc() {
        return new VkDrawIndirectCommand(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDrawIndirectCommand calloc() {
        return new VkDrawIndirectCommand(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDrawIndirectCommand create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDrawIndirectCommand(MemoryUtil.memAddress(container), container);
    }

    public static VkDrawIndirectCommand create(long address) {
        return new VkDrawIndirectCommand(address, null);
    }

    public static @Nullable VkDrawIndirectCommand createSafe(long address) {
        return address == 0L ? null : new VkDrawIndirectCommand(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDrawIndirectCommand.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDrawIndirectCommand.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDrawIndirectCommand mallocStack() {
        return VkDrawIndirectCommand.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDrawIndirectCommand callocStack() {
        return VkDrawIndirectCommand.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDrawIndirectCommand mallocStack(MemoryStack stack) {
        return VkDrawIndirectCommand.malloc(stack);
    }

    @Deprecated
    public static VkDrawIndirectCommand callocStack(MemoryStack stack) {
        return VkDrawIndirectCommand.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDrawIndirectCommand.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDrawIndirectCommand.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDrawIndirectCommand.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDrawIndirectCommand.calloc(capacity, stack);
    }

    public static VkDrawIndirectCommand malloc(MemoryStack stack) {
        return new VkDrawIndirectCommand(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDrawIndirectCommand calloc(MemoryStack stack) {
        return new VkDrawIndirectCommand(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nvertexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXCOUNT);
    }

    public static int ninstanceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INSTANCECOUNT);
    }

    public static int nfirstVertex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTVERTEX);
    }

    public static int nfirstInstance(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRSTINSTANCE);
    }

    public static void nvertexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXCOUNT, value);
    }

    public static void ninstanceCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INSTANCECOUNT, value);
    }

    public static void nfirstVertex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTVERTEX, value);
    }

    public static void nfirstInstance(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRSTINSTANCE, value);
    }

    static {
        Struct.Layout layout = VkDrawIndirectCommand.__struct(VkDrawIndirectCommand.__member(4), VkDrawIndirectCommand.__member(4), VkDrawIndirectCommand.__member(4), VkDrawIndirectCommand.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEXCOUNT = layout.offsetof(0);
        INSTANCECOUNT = layout.offsetof(1);
        FIRSTVERTEX = layout.offsetof(2);
        FIRSTINSTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDrawIndirectCommand, Buffer>
    implements NativeResource {
        private static final VkDrawIndirectCommand ELEMENT_FACTORY = VkDrawIndirectCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDrawIndirectCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return VkDrawIndirectCommand.nvertexCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int instanceCount() {
            return VkDrawIndirectCommand.ninstanceCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstVertex() {
            return VkDrawIndirectCommand.nfirstVertex(this.address());
        }

        @NativeType(value="uint32_t")
        public int firstInstance() {
            return VkDrawIndirectCommand.nfirstInstance(this.address());
        }

        public Buffer vertexCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.nvertexCount(this.address(), value);
            return this;
        }

        public Buffer instanceCount(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.ninstanceCount(this.address(), value);
            return this;
        }

        public Buffer firstVertex(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.nfirstVertex(this.address(), value);
            return this;
        }

        public Buffer firstInstance(@NativeType(value="uint32_t") int value) {
            VkDrawIndirectCommand.nfirstInstance(this.address(), value);
            return this;
        }
    }
}

