/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExportMetalObjectCreateInfoEXT;
import org.lwjgl.vulkan.VkImportMetalSharedEventInfoEXT;

public class VkEventCreateInfo
extends Struct<VkEventCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    protected VkEventCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkEventCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkEventCreateInfo(address, container);
    }

    public VkEventCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkEventCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkEventCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkEventCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkEventCreateFlags")
    public int flags() {
        return VkEventCreateInfo.nflags(this.address());
    }

    public VkEventCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkEventCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkEventCreateInfo sType$Default() {
        return this.sType(10);
    }

    public VkEventCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkEventCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkEventCreateInfo pNext(VkExportMetalObjectCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkEventCreateInfo pNext(VkImportMetalSharedEventInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkEventCreateInfo flags(@NativeType(value="VkEventCreateFlags") int value) {
        VkEventCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkEventCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkEventCreateInfo set(VkEventCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkEventCreateInfo malloc() {
        return new VkEventCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkEventCreateInfo calloc() {
        return new VkEventCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkEventCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkEventCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkEventCreateInfo create(long address) {
        return new VkEventCreateInfo(address, null);
    }

    public static @Nullable VkEventCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkEventCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkEventCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkEventCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkEventCreateInfo mallocStack() {
        return VkEventCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkEventCreateInfo callocStack() {
        return VkEventCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkEventCreateInfo mallocStack(MemoryStack stack) {
        return VkEventCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkEventCreateInfo callocStack(MemoryStack stack) {
        return VkEventCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkEventCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkEventCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkEventCreateInfo.calloc(capacity, stack);
    }

    public static VkEventCreateInfo malloc(MemoryStack stack) {
        return new VkEventCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkEventCreateInfo calloc(MemoryStack stack) {
        return new VkEventCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkEventCreateInfo.__struct(VkEventCreateInfo.__member(4), VkEventCreateInfo.__member(POINTER_SIZE), VkEventCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkEventCreateInfo, Buffer>
    implements NativeResource {
        private static final VkEventCreateInfo ELEMENT_FACTORY = VkEventCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkEventCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkEventCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkEventCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkEventCreateFlags")
        public int flags() {
            return VkEventCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkEventCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(10);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkEventCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExportMetalObjectCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImportMetalSharedEventInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkEventCreateFlags") int value) {
            VkEventCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

