/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtent3D
extends Struct<VkExtent3D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;

    protected VkExtent3D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExtent3D create(long address, @Nullable ByteBuffer container) {
        return new VkExtent3D(address, container);
    }

    public VkExtent3D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExtent3D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkExtent3D.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkExtent3D.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int depth() {
        return VkExtent3D.ndepth(this.address());
    }

    public VkExtent3D width(@NativeType(value="uint32_t") int value) {
        VkExtent3D.nwidth(this.address(), value);
        return this;
    }

    public VkExtent3D height(@NativeType(value="uint32_t") int value) {
        VkExtent3D.nheight(this.address(), value);
        return this;
    }

    public VkExtent3D depth(@NativeType(value="uint32_t") int value) {
        VkExtent3D.ndepth(this.address(), value);
        return this;
    }

    public VkExtent3D set(int width, int height, int depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public VkExtent3D set(VkExtent3D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExtent3D malloc() {
        return new VkExtent3D(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExtent3D calloc() {
        return new VkExtent3D(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExtent3D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExtent3D(MemoryUtil.memAddress(container), container);
    }

    public static VkExtent3D create(long address) {
        return new VkExtent3D(address, null);
    }

    public static @Nullable VkExtent3D createSafe(long address) {
        return address == 0L ? null : new VkExtent3D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExtent3D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExtent3D.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExtent3D mallocStack() {
        return VkExtent3D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent3D callocStack() {
        return VkExtent3D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExtent3D mallocStack(MemoryStack stack) {
        return VkExtent3D.malloc(stack);
    }

    @Deprecated
    public static VkExtent3D callocStack(MemoryStack stack) {
        return VkExtent3D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExtent3D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExtent3D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExtent3D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExtent3D.calloc(capacity, stack);
    }

    public static VkExtent3D malloc(MemoryStack stack) {
        return new VkExtent3D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExtent3D calloc(MemoryStack stack) {
        return new VkExtent3D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = VkExtent3D.__struct(VkExtent3D.__member(4), VkExtent3D.__member(4), VkExtent3D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExtent3D, Buffer>
    implements NativeResource {
        private static final VkExtent3D ELEMENT_FACTORY = VkExtent3D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkExtent3D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkExtent3D.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkExtent3D.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int depth() {
            return VkExtent3D.ndepth(this.address());
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkExtent3D.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkExtent3D.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(@NativeType(value="uint32_t") int value) {
            VkExtent3D.ndepth(this.address(), value);
            return this;
        }
    }
}

