/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageFormatProperties;

public class VkExternalImageFormatPropertiesNV
extends Struct<VkExternalImageFormatPropertiesNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGEFORMATPROPERTIES;
    public static final int EXTERNALMEMORYFEATURES;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;

    protected VkExternalImageFormatPropertiesNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExternalImageFormatPropertiesNV create(long address, @Nullable ByteBuffer container) {
        return new VkExternalImageFormatPropertiesNV(address, container);
    }

    public VkExternalImageFormatPropertiesNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExternalImageFormatPropertiesNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkImageFormatProperties imageFormatProperties() {
        return VkExternalImageFormatPropertiesNV.nimageFormatProperties(this.address());
    }

    @NativeType(value="VkExternalMemoryFeatureFlagsNV")
    public int externalMemoryFeatures() {
        return VkExternalImageFormatPropertiesNV.nexternalMemoryFeatures(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int exportFromImportedHandleTypes() {
        return VkExternalImageFormatPropertiesNV.nexportFromImportedHandleTypes(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int compatibleHandleTypes() {
        return VkExternalImageFormatPropertiesNV.ncompatibleHandleTypes(this.address());
    }

    public static VkExternalImageFormatPropertiesNV malloc() {
        return new VkExternalImageFormatPropertiesNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExternalImageFormatPropertiesNV calloc() {
        return new VkExternalImageFormatPropertiesNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExternalImageFormatPropertiesNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExternalImageFormatPropertiesNV(MemoryUtil.memAddress(container), container);
    }

    public static VkExternalImageFormatPropertiesNV create(long address) {
        return new VkExternalImageFormatPropertiesNV(address, null);
    }

    public static @Nullable VkExternalImageFormatPropertiesNV createSafe(long address) {
        return address == 0L ? null : new VkExternalImageFormatPropertiesNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExternalImageFormatPropertiesNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalImageFormatPropertiesNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV mallocStack() {
        return VkExternalImageFormatPropertiesNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV callocStack() {
        return VkExternalImageFormatPropertiesNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV mallocStack(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.malloc(stack);
    }

    @Deprecated
    public static VkExternalImageFormatPropertiesNV callocStack(MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalImageFormatPropertiesNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalImageFormatPropertiesNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalImageFormatPropertiesNV.calloc(capacity, stack);
    }

    public static VkExternalImageFormatPropertiesNV malloc(MemoryStack stack) {
        return new VkExternalImageFormatPropertiesNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExternalImageFormatPropertiesNV calloc(MemoryStack stack) {
        return new VkExternalImageFormatPropertiesNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkImageFormatProperties nimageFormatProperties(long struct) {
        return VkImageFormatProperties.create(struct + (long)IMAGEFORMATPROPERTIES);
    }

    public static int nexternalMemoryFeatures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXTERNALMEMORYFEATURES);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPATIBLEHANDLETYPES);
    }

    static {
        Struct.Layout layout = VkExternalImageFormatPropertiesNV.__struct(VkExternalImageFormatPropertiesNV.__member(VkImageFormatProperties.SIZEOF, VkImageFormatProperties.ALIGNOF), VkExternalImageFormatPropertiesNV.__member(4), VkExternalImageFormatPropertiesNV.__member(4), VkExternalImageFormatPropertiesNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGEFORMATPROPERTIES = layout.offsetof(0);
        EXTERNALMEMORYFEATURES = layout.offsetof(1);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(2);
        COMPATIBLEHANDLETYPES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkExternalImageFormatPropertiesNV, Buffer>
    implements NativeResource {
        private static final VkExternalImageFormatPropertiesNV ELEMENT_FACTORY = VkExternalImageFormatPropertiesNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkExternalImageFormatPropertiesNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkImageFormatProperties imageFormatProperties() {
            return VkExternalImageFormatPropertiesNV.nimageFormatProperties(this.address());
        }

        @NativeType(value="VkExternalMemoryFeatureFlagsNV")
        public int externalMemoryFeatures() {
            return VkExternalImageFormatPropertiesNV.nexternalMemoryFeatures(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int exportFromImportedHandleTypes() {
            return VkExternalImageFormatPropertiesNV.nexportFromImportedHandleTypes(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int compatibleHandleTypes() {
            return VkExternalImageFormatPropertiesNV.ncompatibleHandleTypes(this.address());
        }
    }
}

