/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExportFenceCreateInfo;
import org.lwjgl.vulkan.VkExportFenceCreateInfoKHR;
import org.lwjgl.vulkan.VkExportFenceWin32HandleInfoKHR;

public class VkFenceCreateInfo
extends Struct<VkFenceCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    protected VkFenceCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkFenceCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkFenceCreateInfo(address, container);
    }

    public VkFenceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkFenceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFenceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFenceCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkFenceCreateFlags")
    public int flags() {
        return VkFenceCreateInfo.nflags(this.address());
    }

    public VkFenceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkFenceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo sType$Default() {
        return this.sType(8);
    }

    public VkFenceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkFenceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo pNext(VkExportFenceCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFenceCreateInfo pNext(VkExportFenceCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFenceCreateInfo pNext(VkExportFenceWin32HandleInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkFenceCreateInfo flags(@NativeType(value="VkFenceCreateFlags") int value) {
        VkFenceCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkFenceCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkFenceCreateInfo set(VkFenceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkFenceCreateInfo malloc() {
        return new VkFenceCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkFenceCreateInfo calloc() {
        return new VkFenceCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkFenceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkFenceCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkFenceCreateInfo create(long address) {
        return new VkFenceCreateInfo(address, null);
    }

    public static @Nullable VkFenceCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkFenceCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkFenceCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFenceCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkFenceCreateInfo mallocStack() {
        return VkFenceCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFenceCreateInfo callocStack() {
        return VkFenceCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkFenceCreateInfo mallocStack(MemoryStack stack) {
        return VkFenceCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkFenceCreateInfo callocStack(MemoryStack stack) {
        return VkFenceCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkFenceCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkFenceCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkFenceCreateInfo.calloc(capacity, stack);
    }

    public static VkFenceCreateInfo malloc(MemoryStack stack) {
        return new VkFenceCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkFenceCreateInfo calloc(MemoryStack stack) {
        return new VkFenceCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkFenceCreateInfo.__struct(VkFenceCreateInfo.__member(4), VkFenceCreateInfo.__member(POINTER_SIZE), VkFenceCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkFenceCreateInfo, Buffer>
    implements NativeResource {
        private static final VkFenceCreateInfo ELEMENT_FACTORY = VkFenceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkFenceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFenceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFenceCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkFenceCreateFlags")
        public int flags() {
            return VkFenceCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFenceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(8);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFenceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExportFenceCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportFenceCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportFenceWin32HandleInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkFenceCreateFlags") int value) {
            VkFenceCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

