/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGeometryAABBNV;
import org.lwjgl.vulkan.VkGeometryTrianglesNV;

public class VkGeometryDataNV
extends Struct<VkGeometryDataNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRIANGLES;
    public static final int AABBS;

    protected VkGeometryDataNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkGeometryDataNV create(long address, @Nullable ByteBuffer container) {
        return new VkGeometryDataNV(address, container);
    }

    public VkGeometryDataNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkGeometryDataNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkGeometryTrianglesNV triangles() {
        return VkGeometryDataNV.ntriangles(this.address());
    }

    public VkGeometryAABBNV aabbs() {
        return VkGeometryDataNV.naabbs(this.address());
    }

    public VkGeometryDataNV triangles(VkGeometryTrianglesNV value) {
        VkGeometryDataNV.ntriangles(this.address(), value);
        return this;
    }

    public VkGeometryDataNV triangles(Consumer<VkGeometryTrianglesNV> consumer) {
        consumer.accept(this.triangles());
        return this;
    }

    public VkGeometryDataNV aabbs(VkGeometryAABBNV value) {
        VkGeometryDataNV.naabbs(this.address(), value);
        return this;
    }

    public VkGeometryDataNV aabbs(Consumer<VkGeometryAABBNV> consumer) {
        consumer.accept(this.aabbs());
        return this;
    }

    public VkGeometryDataNV set(VkGeometryTrianglesNV triangles, VkGeometryAABBNV aabbs) {
        this.triangles(triangles);
        this.aabbs(aabbs);
        return this;
    }

    public VkGeometryDataNV set(VkGeometryDataNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkGeometryDataNV malloc() {
        return new VkGeometryDataNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkGeometryDataNV calloc() {
        return new VkGeometryDataNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkGeometryDataNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkGeometryDataNV(MemoryUtil.memAddress(container), container);
    }

    public static VkGeometryDataNV create(long address) {
        return new VkGeometryDataNV(address, null);
    }

    public static @Nullable VkGeometryDataNV createSafe(long address) {
        return address == 0L ? null : new VkGeometryDataNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkGeometryDataNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGeometryDataNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkGeometryDataNV mallocStack() {
        return VkGeometryDataNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkGeometryDataNV callocStack() {
        return VkGeometryDataNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkGeometryDataNV mallocStack(MemoryStack stack) {
        return VkGeometryDataNV.malloc(stack);
    }

    @Deprecated
    public static VkGeometryDataNV callocStack(MemoryStack stack) {
        return VkGeometryDataNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkGeometryDataNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkGeometryDataNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkGeometryDataNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkGeometryDataNV.calloc(capacity, stack);
    }

    public static VkGeometryDataNV malloc(MemoryStack stack) {
        return new VkGeometryDataNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkGeometryDataNV calloc(MemoryStack stack) {
        return new VkGeometryDataNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkGeometryTrianglesNV ntriangles(long struct) {
        return VkGeometryTrianglesNV.create(struct + (long)TRIANGLES);
    }

    public static VkGeometryAABBNV naabbs(long struct) {
        return VkGeometryAABBNV.create(struct + (long)AABBS);
    }

    public static void ntriangles(long struct, VkGeometryTrianglesNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRIANGLES, VkGeometryTrianglesNV.SIZEOF);
    }

    public static void naabbs(long struct, VkGeometryAABBNV value) {
        MemoryUtil.memCopy(value.address(), struct + (long)AABBS, VkGeometryAABBNV.SIZEOF);
    }

    static {
        Struct.Layout layout = VkGeometryDataNV.__struct(VkGeometryDataNV.__member(VkGeometryTrianglesNV.SIZEOF, VkGeometryTrianglesNV.ALIGNOF), VkGeometryDataNV.__member(VkGeometryAABBNV.SIZEOF, VkGeometryAABBNV.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRIANGLES = layout.offsetof(0);
        AABBS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkGeometryDataNV, Buffer>
    implements NativeResource {
        private static final VkGeometryDataNV ELEMENT_FACTORY = VkGeometryDataNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkGeometryDataNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkGeometryTrianglesNV triangles() {
            return VkGeometryDataNV.ntriangles(this.address());
        }

        public VkGeometryAABBNV aabbs() {
            return VkGeometryDataNV.naabbs(this.address());
        }

        public Buffer triangles(VkGeometryTrianglesNV value) {
            VkGeometryDataNV.ntriangles(this.address(), value);
            return this;
        }

        public Buffer triangles(Consumer<VkGeometryTrianglesNV> consumer) {
            consumer.accept(this.triangles());
            return this;
        }

        public Buffer aabbs(VkGeometryAABBNV value) {
            VkGeometryDataNV.naabbs(this.address(), value);
            return this;
        }

        public Buffer aabbs(Consumer<VkGeometryAABBNV> consumer) {
            consumer.accept(this.aabbs());
            return this;
        }
    }
}

