/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGraphicsShaderGroupCreateInfoNV;

public class VkGraphicsPipelineShaderGroupsCreateInfoNV
extends Struct<VkGraphicsPipelineShaderGroupsCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int GROUPCOUNT;
    public static final int PGROUPS;
    public static final int PIPELINECOUNT;
    public static final int PPIPELINES;

    protected VkGraphicsPipelineShaderGroupsCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkGraphicsPipelineShaderGroupsCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(address, container);
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkGraphicsPipelineShaderGroupsCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int groupCount() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(this.address());
    }

    @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *")
    public @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address());
    }

    @NativeType(value="uint32_t")
    public int pipelineCount() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(this.address());
    }

    @NativeType(value="VkPipeline const *")
    public @Nullable LongBuffer pPipelines() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address());
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV sType$Default() {
        return this.sType(1000277002);
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pGroups(@NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *") @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pPipelines(@NativeType(value="VkPipeline const *") @Nullable LongBuffer value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV set(int sType, long pNext, @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups, @Nullable LongBuffer pPipelines) {
        this.sType(sType);
        this.pNext(pNext);
        this.pGroups(pGroups);
        this.pPipelines(pPipelines);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV set(VkGraphicsPipelineShaderGroupsCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV malloc() {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV calloc() {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV create(long address) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(address, null);
    }

    public static @Nullable VkGraphicsPipelineShaderGroupsCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkGraphicsPipelineShaderGroupsCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkGraphicsPipelineShaderGroupsCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGraphicsPipelineShaderGroupsCreateInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV malloc(MemoryStack stack) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV calloc(MemoryStack stack) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ngroupCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GROUPCOUNT);
    }

    public static @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer npGroups(long struct) {
        return VkGraphicsShaderGroupCreateInfoNV.createSafe(MemoryUtil.memGetAddress(struct + (long)PGROUPS), VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct));
    }

    public static int npipelineCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINECOUNT);
    }

    public static @Nullable LongBuffer npPipelines(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPIPELINES), VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ngroupCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GROUPCOUNT, value);
    }

    public static void npGroups(long struct, @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PGROUPS, MemoryUtil.memAddressSafe(value));
        VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct, value == null ? 0 : value.remaining());
    }

    public static void npipelineCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINECOUNT, value);
    }

    public static void npPipelines(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPIPELINES, MemoryUtil.memAddressSafe(value));
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int groupCount = VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct);
        if (groupCount != 0) {
            long pGroups = MemoryUtil.memGetAddress(struct + (long)PGROUPS);
            Checks.check(pGroups);
            VkGraphicsPipelineShaderGroupsCreateInfoNV.validate(pGroups, groupCount, VkGraphicsShaderGroupCreateInfoNV.SIZEOF, VkGraphicsShaderGroupCreateInfoNV::validate);
        }
        if (VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPIPELINES));
        }
    }

    static {
        Struct.Layout layout = VkGraphicsPipelineShaderGroupsCreateInfoNV.__struct(VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(POINTER_SIZE), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(POINTER_SIZE), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        GROUPCOUNT = layout.offsetof(2);
        PGROUPS = layout.offsetof(3);
        PIPELINECOUNT = layout.offsetof(4);
        PPIPELINES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkGraphicsPipelineShaderGroupsCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkGraphicsPipelineShaderGroupsCreateInfoNV ELEMENT_FACTORY = VkGraphicsPipelineShaderGroupsCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkGraphicsPipelineShaderGroupsCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int groupCount() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(this.address());
        }

        @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *")
        public @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address());
        }

        @NativeType(value="uint32_t")
        public int pipelineCount() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(this.address());
        }

        @NativeType(value="VkPipeline const *")
        public @Nullable LongBuffer pPipelines() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000277002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pGroups(@NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *") @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address(), value);
            return this;
        }

        public Buffer pPipelines(@NativeType(value="VkPipeline const *") @Nullable LongBuffer value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address(), value);
            return this;
        }
    }
}

