/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageCopy2
extends Struct<VkImageCopy2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCSUBRESOURCE;
    public static final int SRCOFFSET;
    public static final int DSTSUBRESOURCE;
    public static final int DSTOFFSET;
    public static final int EXTENT;

    protected VkImageCopy2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageCopy2 create(long address, @Nullable ByteBuffer container) {
        return new VkImageCopy2(address, container);
    }

    public VkImageCopy2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageCopy2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageCopy2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageCopy2.npNext(this.address());
    }

    public VkImageSubresourceLayers srcSubresource() {
        return VkImageCopy2.nsrcSubresource(this.address());
    }

    public VkOffset3D srcOffset() {
        return VkImageCopy2.nsrcOffset(this.address());
    }

    public VkImageSubresourceLayers dstSubresource() {
        return VkImageCopy2.ndstSubresource(this.address());
    }

    public VkOffset3D dstOffset() {
        return VkImageCopy2.ndstOffset(this.address());
    }

    public VkExtent3D extent() {
        return VkImageCopy2.nextent(this.address());
    }

    public VkImageCopy2 sType(@NativeType(value="VkStructureType") int value) {
        VkImageCopy2.nsType(this.address(), value);
        return this;
    }

    public VkImageCopy2 sType$Default() {
        return this.sType(1000337007);
    }

    public VkImageCopy2 pNext(@NativeType(value="void const *") long value) {
        VkImageCopy2.npNext(this.address(), value);
        return this;
    }

    public VkImageCopy2 srcSubresource(VkImageSubresourceLayers value) {
        VkImageCopy2.nsrcSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy2 srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.srcSubresource());
        return this;
    }

    public VkImageCopy2 srcOffset(VkOffset3D value) {
        VkImageCopy2.nsrcOffset(this.address(), value);
        return this;
    }

    public VkImageCopy2 srcOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.srcOffset());
        return this;
    }

    public VkImageCopy2 dstSubresource(VkImageSubresourceLayers value) {
        VkImageCopy2.ndstSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy2 dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.dstSubresource());
        return this;
    }

    public VkImageCopy2 dstOffset(VkOffset3D value) {
        VkImageCopy2.ndstOffset(this.address(), value);
        return this;
    }

    public VkImageCopy2 dstOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.dstOffset());
        return this;
    }

    public VkImageCopy2 extent(VkExtent3D value) {
        VkImageCopy2.nextent(this.address(), value);
        return this;
    }

    public VkImageCopy2 extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkImageCopy2 set(int sType, long pNext, VkImageSubresourceLayers srcSubresource, VkOffset3D srcOffset, VkImageSubresourceLayers dstSubresource, VkOffset3D dstOffset, VkExtent3D extent) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcSubresource(srcSubresource);
        this.srcOffset(srcOffset);
        this.dstSubresource(dstSubresource);
        this.dstOffset(dstOffset);
        this.extent(extent);
        return this;
    }

    public VkImageCopy2 set(VkImageCopy2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageCopy2 malloc() {
        return new VkImageCopy2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageCopy2 calloc() {
        return new VkImageCopy2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageCopy2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageCopy2(MemoryUtil.memAddress(container), container);
    }

    public static VkImageCopy2 create(long address) {
        return new VkImageCopy2(address, null);
    }

    public static @Nullable VkImageCopy2 createSafe(long address) {
        return address == 0L ? null : new VkImageCopy2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageCopy2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageCopy2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageCopy2 malloc(MemoryStack stack) {
        return new VkImageCopy2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageCopy2 calloc(MemoryStack stack) {
        return new VkImageCopy2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkImageSubresourceLayers nsrcSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)SRCSUBRESOURCE);
    }

    public static VkOffset3D nsrcOffset(long struct) {
        return VkOffset3D.create(struct + (long)SRCOFFSET);
    }

    public static VkImageSubresourceLayers ndstSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)DSTSUBRESOURCE);
    }

    public static VkOffset3D ndstOffset(long struct) {
        return VkOffset3D.create(struct + (long)DSTOFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nsrcOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCOFFSET, VkOffset3D.SIZEOF);
    }

    public static void ndstSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTSUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void ndstOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageCopy2.__struct(VkImageCopy2.__member(4), VkImageCopy2.__member(POINTER_SIZE), VkImageCopy2.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageCopy2.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageCopy2.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageCopy2.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageCopy2.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCSUBRESOURCE = layout.offsetof(2);
        SRCOFFSET = layout.offsetof(3);
        DSTSUBRESOURCE = layout.offsetof(4);
        DSTOFFSET = layout.offsetof(5);
        EXTENT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkImageCopy2, Buffer>
    implements NativeResource {
        private static final VkImageCopy2 ELEMENT_FACTORY = VkImageCopy2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImageCopy2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageCopy2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageCopy2.npNext(this.address());
        }

        public VkImageSubresourceLayers srcSubresource() {
            return VkImageCopy2.nsrcSubresource(this.address());
        }

        public VkOffset3D srcOffset() {
            return VkImageCopy2.nsrcOffset(this.address());
        }

        public VkImageSubresourceLayers dstSubresource() {
            return VkImageCopy2.ndstSubresource(this.address());
        }

        public VkOffset3D dstOffset() {
            return VkImageCopy2.ndstOffset(this.address());
        }

        public VkExtent3D extent() {
            return VkImageCopy2.nextent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageCopy2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337007);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageCopy2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcSubresource(VkImageSubresourceLayers value) {
            VkImageCopy2.nsrcSubresource(this.address(), value);
            return this;
        }

        public Buffer srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.srcSubresource());
            return this;
        }

        public Buffer srcOffset(VkOffset3D value) {
            VkImageCopy2.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer srcOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.srcOffset());
            return this;
        }

        public Buffer dstSubresource(VkImageSubresourceLayers value) {
            VkImageCopy2.ndstSubresource(this.address(), value);
            return this;
        }

        public Buffer dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.dstSubresource());
            return this;
        }

        public Buffer dstOffset(VkOffset3D value) {
            VkImageCopy2.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer dstOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.dstOffset());
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageCopy2.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

