/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExternalMemoryAcquireUnmodifiedEXT;
import org.lwjgl.vulkan.VkImageSubresourceRange;
import org.lwjgl.vulkan.VkSampleLocationsInfoEXT;

public class VkImageMemoryBarrier2
extends Struct<VkImageMemoryBarrier2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCSTAGEMASK;
    public static final int SRCACCESSMASK;
    public static final int DSTSTAGEMASK;
    public static final int DSTACCESSMASK;
    public static final int OLDLAYOUT;
    public static final int NEWLAYOUT;
    public static final int SRCQUEUEFAMILYINDEX;
    public static final int DSTQUEUEFAMILYINDEX;
    public static final int IMAGE;
    public static final int SUBRESOURCERANGE;

    protected VkImageMemoryBarrier2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageMemoryBarrier2 create(long address, @Nullable ByteBuffer container) {
        return new VkImageMemoryBarrier2(address, container);
    }

    public VkImageMemoryBarrier2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageMemoryBarrier2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageMemoryBarrier2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageMemoryBarrier2.npNext(this.address());
    }

    @NativeType(value="VkPipelineStageFlags2")
    public long srcStageMask() {
        return VkImageMemoryBarrier2.nsrcStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags2")
    public long srcAccessMask() {
        return VkImageMemoryBarrier2.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkPipelineStageFlags2")
    public long dstStageMask() {
        return VkImageMemoryBarrier2.ndstStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags2")
    public long dstAccessMask() {
        return VkImageMemoryBarrier2.ndstAccessMask(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int oldLayout() {
        return VkImageMemoryBarrier2.noldLayout(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int newLayout() {
        return VkImageMemoryBarrier2.nnewLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcQueueFamilyIndex() {
        return VkImageMemoryBarrier2.nsrcQueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstQueueFamilyIndex() {
        return VkImageMemoryBarrier2.ndstQueueFamilyIndex(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkImageMemoryBarrier2.nimage(this.address());
    }

    public VkImageSubresourceRange subresourceRange() {
        return VkImageMemoryBarrier2.nsubresourceRange(this.address());
    }

    public VkImageMemoryBarrier2 sType(@NativeType(value="VkStructureType") int value) {
        VkImageMemoryBarrier2.nsType(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 sType$Default() {
        return this.sType(1000314002);
    }

    public VkImageMemoryBarrier2 pNext(@NativeType(value="void const *") long value) {
        VkImageMemoryBarrier2.npNext(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 pNext(VkExternalMemoryAcquireUnmodifiedEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageMemoryBarrier2 pNext(VkSampleLocationsInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageMemoryBarrier2 srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkImageMemoryBarrier2.nsrcStageMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkImageMemoryBarrier2.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkImageMemoryBarrier2.ndstStageMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkImageMemoryBarrier2.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 oldLayout(@NativeType(value="VkImageLayout") int value) {
        VkImageMemoryBarrier2.noldLayout(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 newLayout(@NativeType(value="VkImageLayout") int value) {
        VkImageMemoryBarrier2.nnewLayout(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkImageMemoryBarrier2.nsrcQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkImageMemoryBarrier2.ndstQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 image(@NativeType(value="VkImage") long value) {
        VkImageMemoryBarrier2.nimage(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 subresourceRange(VkImageSubresourceRange value) {
        VkImageMemoryBarrier2.nsubresourceRange(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier2 subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
        consumer.accept(this.subresourceRange());
        return this;
    }

    public VkImageMemoryBarrier2 set(int sType, long pNext, long srcStageMask, long srcAccessMask, long dstStageMask, long dstAccessMask, int oldLayout, int newLayout, int srcQueueFamilyIndex, int dstQueueFamilyIndex, long image, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcStageMask(srcStageMask);
        this.srcAccessMask(srcAccessMask);
        this.dstStageMask(dstStageMask);
        this.dstAccessMask(dstAccessMask);
        this.oldLayout(oldLayout);
        this.newLayout(newLayout);
        this.srcQueueFamilyIndex(srcQueueFamilyIndex);
        this.dstQueueFamilyIndex(dstQueueFamilyIndex);
        this.image(image);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkImageMemoryBarrier2 set(VkImageMemoryBarrier2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageMemoryBarrier2 malloc() {
        return new VkImageMemoryBarrier2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageMemoryBarrier2 calloc() {
        return new VkImageMemoryBarrier2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageMemoryBarrier2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageMemoryBarrier2(MemoryUtil.memAddress(container), container);
    }

    public static VkImageMemoryBarrier2 create(long address) {
        return new VkImageMemoryBarrier2(address, null);
    }

    public static @Nullable VkImageMemoryBarrier2 createSafe(long address) {
        return address == 0L ? null : new VkImageMemoryBarrier2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageMemoryBarrier2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageMemoryBarrier2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageMemoryBarrier2 malloc(MemoryStack stack) {
        return new VkImageMemoryBarrier2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageMemoryBarrier2 calloc(MemoryStack stack) {
        return new VkImageMemoryBarrier2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsrcStageMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCSTAGEMASK);
    }

    public static long nsrcAccessMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCACCESSMASK);
    }

    public static long ndstStageMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTSTAGEMASK);
    }

    public static long ndstAccessMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTACCESSMASK);
    }

    public static int noldLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLDLAYOUT);
    }

    public static int nnewLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NEWLAYOUT);
    }

    public static int nsrcQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCQUEUEFAMILYINDEX);
    }

    public static int ndstQueueFamilyIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTQUEUEFAMILYINDEX);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static VkImageSubresourceRange nsubresourceRange(long struct) {
        return VkImageSubresourceRange.create(struct + (long)SUBRESOURCERANGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcStageMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCSTAGEMASK, value);
    }

    public static void nsrcAccessMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstStageMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTSTAGEMASK, value);
    }

    public static void ndstAccessMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTACCESSMASK, value);
    }

    public static void noldLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OLDLAYOUT, value);
    }

    public static void nnewLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NEWLAYOUT, value);
    }

    public static void nsrcQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCQUEUEFAMILYINDEX, value);
    }

    public static void ndstQueueFamilyIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTQUEUEFAMILYINDEX, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nsubresourceRange(long struct, VkImageSubresourceRange value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBRESOURCERANGE, VkImageSubresourceRange.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageMemoryBarrier2.__struct(VkImageMemoryBarrier2.__member(4), VkImageMemoryBarrier2.__member(POINTER_SIZE), VkImageMemoryBarrier2.__member(8), VkImageMemoryBarrier2.__member(8), VkImageMemoryBarrier2.__member(8), VkImageMemoryBarrier2.__member(8), VkImageMemoryBarrier2.__member(4), VkImageMemoryBarrier2.__member(4), VkImageMemoryBarrier2.__member(4), VkImageMemoryBarrier2.__member(4), VkImageMemoryBarrier2.__member(8), VkImageMemoryBarrier2.__member(VkImageSubresourceRange.SIZEOF, VkImageSubresourceRange.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCSTAGEMASK = layout.offsetof(2);
        SRCACCESSMASK = layout.offsetof(3);
        DSTSTAGEMASK = layout.offsetof(4);
        DSTACCESSMASK = layout.offsetof(5);
        OLDLAYOUT = layout.offsetof(6);
        NEWLAYOUT = layout.offsetof(7);
        SRCQUEUEFAMILYINDEX = layout.offsetof(8);
        DSTQUEUEFAMILYINDEX = layout.offsetof(9);
        IMAGE = layout.offsetof(10);
        SUBRESOURCERANGE = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkImageMemoryBarrier2, Buffer>
    implements NativeResource {
        private static final VkImageMemoryBarrier2 ELEMENT_FACTORY = VkImageMemoryBarrier2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImageMemoryBarrier2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageMemoryBarrier2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageMemoryBarrier2.npNext(this.address());
        }

        @NativeType(value="VkPipelineStageFlags2")
        public long srcStageMask() {
            return VkImageMemoryBarrier2.nsrcStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags2")
        public long srcAccessMask() {
            return VkImageMemoryBarrier2.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkPipelineStageFlags2")
        public long dstStageMask() {
            return VkImageMemoryBarrier2.ndstStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags2")
        public long dstAccessMask() {
            return VkImageMemoryBarrier2.ndstAccessMask(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int oldLayout() {
            return VkImageMemoryBarrier2.noldLayout(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int newLayout() {
            return VkImageMemoryBarrier2.nnewLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcQueueFamilyIndex() {
            return VkImageMemoryBarrier2.nsrcQueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstQueueFamilyIndex() {
            return VkImageMemoryBarrier2.ndstQueueFamilyIndex(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkImageMemoryBarrier2.nimage(this.address());
        }

        public VkImageSubresourceRange subresourceRange() {
            return VkImageMemoryBarrier2.nsubresourceRange(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageMemoryBarrier2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000314002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageMemoryBarrier2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExternalMemoryAcquireUnmodifiedEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSampleLocationsInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkImageMemoryBarrier2.nsrcStageMask(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkImageMemoryBarrier2.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkImageMemoryBarrier2.ndstStageMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkImageMemoryBarrier2.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer oldLayout(@NativeType(value="VkImageLayout") int value) {
            VkImageMemoryBarrier2.noldLayout(this.address(), value);
            return this;
        }

        public Buffer newLayout(@NativeType(value="VkImageLayout") int value) {
            VkImageMemoryBarrier2.nnewLayout(this.address(), value);
            return this;
        }

        public Buffer srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkImageMemoryBarrier2.nsrcQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkImageMemoryBarrier2.ndstQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkImageMemoryBarrier2.nimage(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkImageMemoryBarrier2.nsubresourceRange(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
            consumer.accept(this.subresourceRange());
            return this;
        }
    }
}

