/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkImagePlaneMemoryRequirementsInfo;

public class VkImagePlaneMemoryRequirementsInfoKHR
extends VkImagePlaneMemoryRequirementsInfo {
    protected VkImagePlaneMemoryRequirementsInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImagePlaneMemoryRequirementsInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkImagePlaneMemoryRequirementsInfoKHR(address, container);
    }

    public VkImagePlaneMemoryRequirementsInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImagePlaneMemoryRequirementsInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR sType$Default() {
        return this.sType(1000156003);
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImagePlaneMemoryRequirementsInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkImagePlaneMemoryRequirementsInfoKHR.nplaneAspect(this.address(), value);
        return this;
    }

    @Override
    public VkImagePlaneMemoryRequirementsInfoKHR set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkImagePlaneMemoryRequirementsInfoKHR set(VkImagePlaneMemoryRequirementsInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR malloc() {
        return new VkImagePlaneMemoryRequirementsInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR calloc() {
        return new VkImagePlaneMemoryRequirementsInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImagePlaneMemoryRequirementsInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR create(long address) {
        return new VkImagePlaneMemoryRequirementsInfoKHR(address, null);
    }

    public static @Nullable VkImagePlaneMemoryRequirementsInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkImagePlaneMemoryRequirementsInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImagePlaneMemoryRequirementsInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImagePlaneMemoryRequirementsInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImagePlaneMemoryRequirementsInfoKHR mallocStack() {
        return VkImagePlaneMemoryRequirementsInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImagePlaneMemoryRequirementsInfoKHR callocStack() {
        return VkImagePlaneMemoryRequirementsInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImagePlaneMemoryRequirementsInfoKHR mallocStack(MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkImagePlaneMemoryRequirementsInfoKHR callocStack(MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImagePlaneMemoryRequirementsInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImagePlaneMemoryRequirementsInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImagePlaneMemoryRequirementsInfoKHR.calloc(capacity, stack);
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR malloc(MemoryStack stack) {
        return new VkImagePlaneMemoryRequirementsInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImagePlaneMemoryRequirementsInfoKHR calloc(MemoryStack stack) {
        return new VkImagePlaneMemoryRequirementsInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkImagePlaneMemoryRequirementsInfo.Buffer {
        private static final VkImagePlaneMemoryRequirementsInfoKHR ELEMENT_FACTORY = VkImagePlaneMemoryRequirementsInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImagePlaneMemoryRequirementsInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImagePlaneMemoryRequirementsInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000156003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImagePlaneMemoryRequirementsInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkImagePlaneMemoryRequirementsInfoKHR.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

