/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageSubresource;

public class VkImageSubresource2
extends Struct<VkImageSubresource2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGESUBRESOURCE;

    protected VkImageSubresource2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageSubresource2 create(long address, @Nullable ByteBuffer container) {
        return new VkImageSubresource2(address, container);
    }

    public VkImageSubresource2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageSubresource2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageSubresource2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkImageSubresource2.npNext(this.address());
    }

    public VkImageSubresource imageSubresource() {
        return VkImageSubresource2.nimageSubresource(this.address());
    }

    public VkImageSubresource2 sType(@NativeType(value="VkStructureType") int value) {
        VkImageSubresource2.nsType(this.address(), value);
        return this;
    }

    public VkImageSubresource2 sType$Default() {
        return this.sType(1000338003);
    }

    public VkImageSubresource2 pNext(@NativeType(value="void *") long value) {
        VkImageSubresource2.npNext(this.address(), value);
        return this;
    }

    public VkImageSubresource2 imageSubresource(VkImageSubresource value) {
        VkImageSubresource2.nimageSubresource(this.address(), value);
        return this;
    }

    public VkImageSubresource2 imageSubresource(Consumer<VkImageSubresource> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkImageSubresource2 set(int sType, long pNext, VkImageSubresource imageSubresource) {
        this.sType(sType);
        this.pNext(pNext);
        this.imageSubresource(imageSubresource);
        return this;
    }

    public VkImageSubresource2 set(VkImageSubresource2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageSubresource2 malloc() {
        return new VkImageSubresource2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageSubresource2 calloc() {
        return new VkImageSubresource2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageSubresource2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageSubresource2(MemoryUtil.memAddress(container), container);
    }

    public static VkImageSubresource2 create(long address) {
        return new VkImageSubresource2(address, null);
    }

    public static @Nullable VkImageSubresource2 createSafe(long address) {
        return address == 0L ? null : new VkImageSubresource2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageSubresource2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageSubresource2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageSubresource2 malloc(MemoryStack stack) {
        return new VkImageSubresource2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageSubresource2 calloc(MemoryStack stack) {
        return new VkImageSubresource2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkImageSubresource nimageSubresource(long struct) {
        return VkImageSubresource.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresource value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGESUBRESOURCE, VkImageSubresource.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageSubresource2.__struct(VkImageSubresource2.__member(4), VkImageSubresource2.__member(POINTER_SIZE), VkImageSubresource2.__member(VkImageSubresource.SIZEOF, VkImageSubresource.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGESUBRESOURCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImageSubresource2, Buffer>
    implements NativeResource {
        private static final VkImageSubresource2 ELEMENT_FACTORY = VkImageSubresource2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImageSubresource2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageSubresource2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkImageSubresource2.npNext(this.address());
        }

        public VkImageSubresource imageSubresource() {
            return VkImageSubresource2.nimageSubresource(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageSubresource2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000338003);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkImageSubresource2.npNext(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresource value) {
            VkImageSubresource2.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresource> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }
    }
}

