/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageSubresourceRange
extends Struct<VkImageSubresourceRange>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int BASEMIPLEVEL;
    public static final int LEVELCOUNT;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    protected VkImageSubresourceRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageSubresourceRange create(long address, @Nullable ByteBuffer container) {
        return new VkImageSubresourceRange(address, container);
    }

    public VkImageSubresourceRange(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageSubresourceRange.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkImageSubresourceRange.naspectMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int baseMipLevel() {
        return VkImageSubresourceRange.nbaseMipLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int levelCount() {
        return VkImageSubresourceRange.nlevelCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int baseArrayLayer() {
        return VkImageSubresourceRange.nbaseArrayLayer(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkImageSubresourceRange.nlayerCount(this.address());
    }

    public VkImageSubresourceRange aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkImageSubresourceRange.naspectMask(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange baseMipLevel(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nbaseMipLevel(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange levelCount(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nlevelCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange baseArrayLayer(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange layerCount(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nlayerCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange set(int aspectMask, int baseMipLevel, int levelCount, int baseArrayLayer, int layerCount) {
        this.aspectMask(aspectMask);
        this.baseMipLevel(baseMipLevel);
        this.levelCount(levelCount);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkImageSubresourceRange set(VkImageSubresourceRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageSubresourceRange malloc() {
        return new VkImageSubresourceRange(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageSubresourceRange calloc() {
        return new VkImageSubresourceRange(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageSubresourceRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageSubresourceRange(MemoryUtil.memAddress(container), container);
    }

    public static VkImageSubresourceRange create(long address) {
        return new VkImageSubresourceRange(address, null);
    }

    public static @Nullable VkImageSubresourceRange createSafe(long address) {
        return address == 0L ? null : new VkImageSubresourceRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageSubresourceRange.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageSubresourceRange.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImageSubresourceRange mallocStack() {
        return VkImageSubresourceRange.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageSubresourceRange callocStack() {
        return VkImageSubresourceRange.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageSubresourceRange mallocStack(MemoryStack stack) {
        return VkImageSubresourceRange.malloc(stack);
    }

    @Deprecated
    public static VkImageSubresourceRange callocStack(MemoryStack stack) {
        return VkImageSubresourceRange.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageSubresourceRange.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageSubresourceRange.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceRange.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageSubresourceRange.calloc(capacity, stack);
    }

    public static VkImageSubresourceRange malloc(MemoryStack stack) {
        return new VkImageSubresourceRange(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageSubresourceRange calloc(MemoryStack stack) {
        return new VkImageSubresourceRange(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ASPECTMASK);
    }

    public static int nbaseMipLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEMIPLEVEL);
    }

    public static int nlevelCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LEVELCOUNT);
    }

    public static int nbaseArrayLayer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERCOUNT);
    }

    public static void naspectMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ASPECTMASK, value);
    }

    public static void nbaseMipLevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEMIPLEVEL, value);
    }

    public static void nlevelCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LEVELCOUNT, value);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkImageSubresourceRange.__struct(VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4), VkImageSubresourceRange.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        BASEMIPLEVEL = layout.offsetof(1);
        LEVELCOUNT = layout.offsetof(2);
        BASEARRAYLAYER = layout.offsetof(3);
        LAYERCOUNT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageSubresourceRange, Buffer>
    implements NativeResource {
        private static final VkImageSubresourceRange ELEMENT_FACTORY = VkImageSubresourceRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImageSubresourceRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkImageSubresourceRange.naspectMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int baseMipLevel() {
            return VkImageSubresourceRange.nbaseMipLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int levelCount() {
            return VkImageSubresourceRange.nlevelCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int baseArrayLayer() {
            return VkImageSubresourceRange.nbaseArrayLayer(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkImageSubresourceRange.nlayerCount(this.address());
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkImageSubresourceRange.naspectMask(this.address(), value);
            return this;
        }

        public Buffer baseMipLevel(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nbaseMipLevel(this.address(), value);
            return this;
        }

        public Buffer levelCount(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nlevelCount(this.address(), value);
            return this;
        }

        public Buffer baseArrayLayer(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nlayerCount(this.address(), value);
            return this;
        }
    }
}

