/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageToMemoryCopy
extends Struct<VkImageToMemoryCopy>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHOSTPOINTER;
    public static final int MEMORYROWLENGTH;
    public static final int MEMORYIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    protected VkImageToMemoryCopy(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageToMemoryCopy create(long address, @Nullable ByteBuffer container) {
        return new VkImageToMemoryCopy(address, container);
    }

    public VkImageToMemoryCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageToMemoryCopy.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageToMemoryCopy.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageToMemoryCopy.npNext(this.address());
    }

    @NativeType(value="void *")
    public long pHostPointer() {
        return VkImageToMemoryCopy.npHostPointer(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryRowLength() {
        return VkImageToMemoryCopy.nmemoryRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryImageHeight() {
        return VkImageToMemoryCopy.nmemoryImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkImageToMemoryCopy.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkImageToMemoryCopy.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkImageToMemoryCopy.nimageExtent(this.address());
    }

    public VkImageToMemoryCopy sType(@NativeType(value="VkStructureType") int value) {
        VkImageToMemoryCopy.nsType(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy sType$Default() {
        return this.sType(1000270003);
    }

    public VkImageToMemoryCopy pNext(@NativeType(value="void const *") long value) {
        VkImageToMemoryCopy.npNext(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy pHostPointer(@NativeType(value="void *") long value) {
        VkImageToMemoryCopy.npHostPointer(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy memoryRowLength(@NativeType(value="uint32_t") int value) {
        VkImageToMemoryCopy.nmemoryRowLength(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy memoryImageHeight(@NativeType(value="uint32_t") int value) {
        VkImageToMemoryCopy.nmemoryImageHeight(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy imageSubresource(VkImageSubresourceLayers value) {
        VkImageToMemoryCopy.nimageSubresource(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkImageToMemoryCopy imageOffset(VkOffset3D value) {
        VkImageToMemoryCopy.nimageOffset(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkImageToMemoryCopy imageExtent(VkExtent3D value) {
        VkImageToMemoryCopy.nimageExtent(this.address(), value);
        return this;
    }

    public VkImageToMemoryCopy imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkImageToMemoryCopy set(int sType, long pNext, long pHostPointer, int memoryRowLength, int memoryImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.pHostPointer(pHostPointer);
        this.memoryRowLength(memoryRowLength);
        this.memoryImageHeight(memoryImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkImageToMemoryCopy set(VkImageToMemoryCopy src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageToMemoryCopy malloc() {
        return new VkImageToMemoryCopy(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageToMemoryCopy calloc() {
        return new VkImageToMemoryCopy(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageToMemoryCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageToMemoryCopy(MemoryUtil.memAddress(container), container);
    }

    public static VkImageToMemoryCopy create(long address) {
        return new VkImageToMemoryCopy(address, null);
    }

    public static @Nullable VkImageToMemoryCopy createSafe(long address) {
        return address == 0L ? null : new VkImageToMemoryCopy(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageToMemoryCopy.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageToMemoryCopy.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageToMemoryCopy malloc(MemoryStack stack) {
        return new VkImageToMemoryCopy(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageToMemoryCopy calloc(MemoryStack stack) {
        return new VkImageToMemoryCopy(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long npHostPointer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER);
    }

    public static int nmemoryRowLength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYROWLENGTH);
    }

    public static int nmemoryImageHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYIMAGEHEIGHT);
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npHostPointer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PHOSTPOINTER, Checks.check(value));
    }

    public static void nmemoryRowLength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYROWLENGTH, value);
    }

    public static void nmemoryImageHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYIMAGEHEIGHT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGESUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEEXTENT, VkExtent3D.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER));
    }

    static {
        Struct.Layout layout = VkImageToMemoryCopy.__struct(VkImageToMemoryCopy.__member(4), VkImageToMemoryCopy.__member(POINTER_SIZE), VkImageToMemoryCopy.__member(POINTER_SIZE), VkImageToMemoryCopy.__member(4), VkImageToMemoryCopy.__member(4), VkImageToMemoryCopy.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkImageToMemoryCopy.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkImageToMemoryCopy.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHOSTPOINTER = layout.offsetof(2);
        MEMORYROWLENGTH = layout.offsetof(3);
        MEMORYIMAGEHEIGHT = layout.offsetof(4);
        IMAGESUBRESOURCE = layout.offsetof(5);
        IMAGEOFFSET = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkImageToMemoryCopy, Buffer>
    implements NativeResource {
        private static final VkImageToMemoryCopy ELEMENT_FACTORY = VkImageToMemoryCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImageToMemoryCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageToMemoryCopy.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageToMemoryCopy.npNext(this.address());
        }

        @NativeType(value="void *")
        public long pHostPointer() {
            return VkImageToMemoryCopy.npHostPointer(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryRowLength() {
            return VkImageToMemoryCopy.nmemoryRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryImageHeight() {
            return VkImageToMemoryCopy.nmemoryImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkImageToMemoryCopy.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkImageToMemoryCopy.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkImageToMemoryCopy.nimageExtent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageToMemoryCopy.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageToMemoryCopy.npNext(this.address(), value);
            return this;
        }

        public Buffer pHostPointer(@NativeType(value="void *") long value) {
            VkImageToMemoryCopy.npHostPointer(this.address(), value);
            return this;
        }

        public Buffer memoryRowLength(@NativeType(value="uint32_t") int value) {
            VkImageToMemoryCopy.nmemoryRowLength(this.address(), value);
            return this;
        }

        public Buffer memoryImageHeight(@NativeType(value="uint32_t") int value) {
            VkImageToMemoryCopy.nmemoryImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkImageToMemoryCopy.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkImageToMemoryCopy.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkImageToMemoryCopy.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

