/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkIndirectCommandsStreamNV
extends Struct<VkIndirectCommandsStreamNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int OFFSET;

    protected VkIndirectCommandsStreamNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkIndirectCommandsStreamNV create(long address, @Nullable ByteBuffer container) {
        return new VkIndirectCommandsStreamNV(address, container);
    }

    public VkIndirectCommandsStreamNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkIndirectCommandsStreamNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkIndirectCommandsStreamNV.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkIndirectCommandsStreamNV.noffset(this.address());
    }

    public VkIndirectCommandsStreamNV buffer(@NativeType(value="VkBuffer") long value) {
        VkIndirectCommandsStreamNV.nbuffer(this.address(), value);
        return this;
    }

    public VkIndirectCommandsStreamNV offset(@NativeType(value="VkDeviceSize") long value) {
        VkIndirectCommandsStreamNV.noffset(this.address(), value);
        return this;
    }

    public VkIndirectCommandsStreamNV set(long buffer, long offset) {
        this.buffer(buffer);
        this.offset(offset);
        return this;
    }

    public VkIndirectCommandsStreamNV set(VkIndirectCommandsStreamNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkIndirectCommandsStreamNV malloc() {
        return new VkIndirectCommandsStreamNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkIndirectCommandsStreamNV calloc() {
        return new VkIndirectCommandsStreamNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkIndirectCommandsStreamNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkIndirectCommandsStreamNV(MemoryUtil.memAddress(container), container);
    }

    public static VkIndirectCommandsStreamNV create(long address) {
        return new VkIndirectCommandsStreamNV(address, null);
    }

    public static @Nullable VkIndirectCommandsStreamNV createSafe(long address) {
        return address == 0L ? null : new VkIndirectCommandsStreamNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkIndirectCommandsStreamNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectCommandsStreamNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkIndirectCommandsStreamNV malloc(MemoryStack stack) {
        return new VkIndirectCommandsStreamNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkIndirectCommandsStreamNV calloc(MemoryStack stack) {
        return new VkIndirectCommandsStreamNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    static {
        Struct.Layout layout = VkIndirectCommandsStreamNV.__struct(VkIndirectCommandsStreamNV.__member(8), VkIndirectCommandsStreamNV.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsStreamNV, Buffer>
    implements NativeResource {
        private static final VkIndirectCommandsStreamNV ELEMENT_FACTORY = VkIndirectCommandsStreamNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkIndirectCommandsStreamNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkIndirectCommandsStreamNV.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkIndirectCommandsStreamNV.noffset(this.address());
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkIndirectCommandsStreamNV.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkIndirectCommandsStreamNV.noffset(this.address(), value);
            return this;
        }
    }
}

