/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkApplicationInfo;
import org.lwjgl.vulkan.VkDebugReportCallbackCreateInfoEXT;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.vulkan.VkDirectDriverLoadingListLUNARG;
import org.lwjgl.vulkan.VkExportMetalObjectCreateInfoEXT;
import org.lwjgl.vulkan.VkLayerSettingsCreateInfoEXT;
import org.lwjgl.vulkan.VkValidationFeaturesEXT;
import org.lwjgl.vulkan.VkValidationFlagsEXT;

public class VkInstanceCreateInfo
extends Struct<VkInstanceCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PAPPLICATIONINFO;
    public static final int ENABLEDLAYERCOUNT;
    public static final int PPENABLEDLAYERNAMES;
    public static final int ENABLEDEXTENSIONCOUNT;
    public static final int PPENABLEDEXTENSIONNAMES;

    protected VkInstanceCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkInstanceCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkInstanceCreateInfo(address, container);
    }

    public VkInstanceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkInstanceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkInstanceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkInstanceCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkInstanceCreateFlags")
    public int flags() {
        return VkInstanceCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkApplicationInfo const *")
    public @Nullable VkApplicationInfo pApplicationInfo() {
        return VkInstanceCreateInfo.npApplicationInfo(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledLayerCount() {
        return VkInstanceCreateInfo.nenabledLayerCount(this.address());
    }

    @NativeType(value="char const * const *")
    public @Nullable PointerBuffer ppEnabledLayerNames() {
        return VkInstanceCreateInfo.nppEnabledLayerNames(this.address());
    }

    @NativeType(value="uint32_t")
    public int enabledExtensionCount() {
        return VkInstanceCreateInfo.nenabledExtensionCount(this.address());
    }

    @NativeType(value="char const * const *")
    public @Nullable PointerBuffer ppEnabledExtensionNames() {
        return VkInstanceCreateInfo.nppEnabledExtensionNames(this.address());
    }

    public VkInstanceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkInstanceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo sType$Default() {
        return this.sType(1);
    }

    public VkInstanceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkInstanceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo pNext(VkDebugReportCallbackCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkInstanceCreateInfo pNext(VkDebugUtilsMessengerCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkInstanceCreateInfo pNext(VkDirectDriverLoadingListLUNARG value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkInstanceCreateInfo pNext(VkExportMetalObjectCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkInstanceCreateInfo pNext(VkLayerSettingsCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkInstanceCreateInfo pNext(VkValidationFeaturesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkInstanceCreateInfo pNext(VkValidationFlagsEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkInstanceCreateInfo flags(@NativeType(value="VkInstanceCreateFlags") int value) {
        VkInstanceCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo pApplicationInfo(@NativeType(value="VkApplicationInfo const *") @Nullable VkApplicationInfo value) {
        VkInstanceCreateInfo.npApplicationInfo(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo ppEnabledLayerNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
        VkInstanceCreateInfo.nppEnabledLayerNames(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo ppEnabledExtensionNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
        VkInstanceCreateInfo.nppEnabledExtensionNames(this.address(), value);
        return this;
    }

    public VkInstanceCreateInfo set(int sType, long pNext, int flags, @Nullable VkApplicationInfo pApplicationInfo, @Nullable PointerBuffer ppEnabledLayerNames, @Nullable PointerBuffer ppEnabledExtensionNames) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pApplicationInfo(pApplicationInfo);
        this.ppEnabledLayerNames(ppEnabledLayerNames);
        this.ppEnabledExtensionNames(ppEnabledExtensionNames);
        return this;
    }

    public VkInstanceCreateInfo set(VkInstanceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkInstanceCreateInfo malloc() {
        return new VkInstanceCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkInstanceCreateInfo calloc() {
        return new VkInstanceCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkInstanceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkInstanceCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkInstanceCreateInfo create(long address) {
        return new VkInstanceCreateInfo(address, null);
    }

    public static @Nullable VkInstanceCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkInstanceCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkInstanceCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkInstanceCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkInstanceCreateInfo mallocStack() {
        return VkInstanceCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkInstanceCreateInfo callocStack() {
        return VkInstanceCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkInstanceCreateInfo mallocStack(MemoryStack stack) {
        return VkInstanceCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkInstanceCreateInfo callocStack(MemoryStack stack) {
        return VkInstanceCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkInstanceCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkInstanceCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkInstanceCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkInstanceCreateInfo.calloc(capacity, stack);
    }

    public static VkInstanceCreateInfo malloc(MemoryStack stack) {
        return new VkInstanceCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkInstanceCreateInfo calloc(MemoryStack stack) {
        return new VkInstanceCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static @Nullable VkApplicationInfo npApplicationInfo(long struct) {
        return VkApplicationInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PAPPLICATIONINFO));
    }

    public static int nenabledLayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLEDLAYERCOUNT);
    }

    public static @Nullable PointerBuffer nppEnabledLayerNames(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPENABLEDLAYERNAMES), VkInstanceCreateInfo.nenabledLayerCount(struct));
    }

    public static int nenabledExtensionCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ENABLEDEXTENSIONCOUNT);
    }

    public static @Nullable PointerBuffer nppEnabledExtensionNames(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPENABLEDEXTENSIONNAMES), VkInstanceCreateInfo.nenabledExtensionCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npApplicationInfo(long struct, @Nullable VkApplicationInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PAPPLICATIONINFO, MemoryUtil.memAddressSafe(value));
    }

    public static void nenabledLayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENABLEDLAYERCOUNT, value);
    }

    public static void nppEnabledLayerNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPENABLEDLAYERNAMES, MemoryUtil.memAddressSafe(value));
        VkInstanceCreateInfo.nenabledLayerCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nenabledExtensionCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ENABLEDEXTENSIONCOUNT, value);
    }

    public static void nppEnabledExtensionNames(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPENABLEDEXTENSIONNAMES, MemoryUtil.memAddressSafe(value));
        VkInstanceCreateInfo.nenabledExtensionCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkInstanceCreateInfo.nenabledLayerCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPENABLEDLAYERNAMES));
        }
        if (VkInstanceCreateInfo.nenabledExtensionCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPENABLEDEXTENSIONNAMES));
        }
    }

    static {
        Struct.Layout layout = VkInstanceCreateInfo.__struct(VkInstanceCreateInfo.__member(4), VkInstanceCreateInfo.__member(POINTER_SIZE), VkInstanceCreateInfo.__member(4), VkInstanceCreateInfo.__member(POINTER_SIZE), VkInstanceCreateInfo.__member(4), VkInstanceCreateInfo.__member(POINTER_SIZE), VkInstanceCreateInfo.__member(4), VkInstanceCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PAPPLICATIONINFO = layout.offsetof(3);
        ENABLEDLAYERCOUNT = layout.offsetof(4);
        PPENABLEDLAYERNAMES = layout.offsetof(5);
        ENABLEDEXTENSIONCOUNT = layout.offsetof(6);
        PPENABLEDEXTENSIONNAMES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkInstanceCreateInfo, Buffer>
    implements NativeResource {
        private static final VkInstanceCreateInfo ELEMENT_FACTORY = VkInstanceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkInstanceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkInstanceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkInstanceCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkInstanceCreateFlags")
        public int flags() {
            return VkInstanceCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkApplicationInfo const *")
        public @Nullable VkApplicationInfo pApplicationInfo() {
            return VkInstanceCreateInfo.npApplicationInfo(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledLayerCount() {
            return VkInstanceCreateInfo.nenabledLayerCount(this.address());
        }

        @NativeType(value="char const * const *")
        public @Nullable PointerBuffer ppEnabledLayerNames() {
            return VkInstanceCreateInfo.nppEnabledLayerNames(this.address());
        }

        @NativeType(value="uint32_t")
        public int enabledExtensionCount() {
            return VkInstanceCreateInfo.nenabledExtensionCount(this.address());
        }

        @NativeType(value="char const * const *")
        public @Nullable PointerBuffer ppEnabledExtensionNames() {
            return VkInstanceCreateInfo.nppEnabledExtensionNames(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkInstanceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkInstanceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDebugReportCallbackCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDebugUtilsMessengerCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDirectDriverLoadingListLUNARG value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportMetalObjectCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkLayerSettingsCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkValidationFeaturesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkValidationFlagsEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkInstanceCreateFlags") int value) {
            VkInstanceCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pApplicationInfo(@NativeType(value="VkApplicationInfo const *") @Nullable VkApplicationInfo value) {
            VkInstanceCreateInfo.npApplicationInfo(this.address(), value);
            return this;
        }

        public Buffer ppEnabledLayerNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
            VkInstanceCreateInfo.nppEnabledLayerNames(this.address(), value);
            return this;
        }

        public Buffer ppEnabledExtensionNames(@NativeType(value="char const * const *") @Nullable PointerBuffer value) {
            VkInstanceCreateInfo.nppEnabledExtensionNames(this.address(), value);
            return this;
        }
    }
}

