/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHeap
extends Struct<VkMemoryHeap> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int FLAGS;

    protected VkMemoryHeap(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryHeap create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryHeap(address, container);
    }

    public VkMemoryHeap(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryHeap.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryHeap.nsize(this.address());
    }

    @NativeType(value="VkMemoryHeapFlags")
    public int flags() {
        return VkMemoryHeap.nflags(this.address());
    }

    public static VkMemoryHeap create(long address) {
        return new VkMemoryHeap(address, null);
    }

    public static @Nullable VkMemoryHeap createSafe(long address) {
        return address == 0L ? null : new VkMemoryHeap(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = VkMemoryHeap.__struct(VkMemoryHeap.__member(8), VkMemoryHeap.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryHeap, Buffer> {
        private static final VkMemoryHeap ELEMENT_FACTORY = VkMemoryHeap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryHeap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryHeap.nsize(this.address());
        }

        @NativeType(value="VkMemoryHeapFlags")
        public int flags() {
            return VkMemoryHeap.nflags(this.address());
        }
    }
}

