/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHostPointerPropertiesEXT
extends Struct<VkMemoryHostPointerPropertiesEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYTYPEBITS;

    protected VkMemoryHostPointerPropertiesEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryHostPointerPropertiesEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryHostPointerPropertiesEXT(address, container);
    }

    public VkMemoryHostPointerPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryHostPointerPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
    }

    public VkMemoryHostPointerPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT sType$Default() {
        return this.sType(1000178001);
    }

    public VkMemoryHostPointerPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryHostPointerPropertiesEXT set(VkMemoryHostPointerPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryHostPointerPropertiesEXT malloc() {
        return new VkMemoryHostPointerPropertiesEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryHostPointerPropertiesEXT calloc() {
        return new VkMemoryHostPointerPropertiesEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryHostPointerPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryHostPointerPropertiesEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryHostPointerPropertiesEXT create(long address) {
        return new VkMemoryHostPointerPropertiesEXT(address, null);
    }

    public static @Nullable VkMemoryHostPointerPropertiesEXT createSafe(long address) {
        return address == 0L ? null : new VkMemoryHostPointerPropertiesEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryHostPointerPropertiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryHostPointerPropertiesEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT mallocStack() {
        return VkMemoryHostPointerPropertiesEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT callocStack() {
        return VkMemoryHostPointerPropertiesEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT mallocStack(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.malloc(stack);
    }

    @Deprecated
    public static VkMemoryHostPointerPropertiesEXT callocStack(MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryHostPointerPropertiesEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryHostPointerPropertiesEXT.calloc(capacity, stack);
    }

    public static VkMemoryHostPointerPropertiesEXT malloc(MemoryStack stack) {
        return new VkMemoryHostPointerPropertiesEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryHostPointerPropertiesEXT calloc(MemoryStack stack) {
        return new VkMemoryHostPointerPropertiesEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmemoryTypeBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEBITS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkMemoryHostPointerPropertiesEXT.__struct(VkMemoryHostPointerPropertiesEXT.__member(4), VkMemoryHostPointerPropertiesEXT.__member(POINTER_SIZE), VkMemoryHostPointerPropertiesEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryHostPointerPropertiesEXT, Buffer>
    implements NativeResource {
        private static final VkMemoryHostPointerPropertiesEXT ELEMENT_FACTORY = VkMemoryHostPointerPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryHostPointerPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryHostPointerPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryHostPointerPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryHostPointerPropertiesEXT.nmemoryTypeBits(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryHostPointerPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000178001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryHostPointerPropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

