/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryMapPlacedInfoEXT;

public class VkMemoryMapInfo
extends Struct<VkMemoryMapInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MEMORY;
    public static final int OFFSET;
    public static final int SIZE;

    protected VkMemoryMapInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryMapInfo create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryMapInfo(address, container);
    }

    public VkMemoryMapInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryMapInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryMapInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryMapInfo.npNext(this.address());
    }

    @NativeType(value="VkMemoryMapFlags")
    public int flags() {
        return VkMemoryMapInfo.nflags(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryMapInfo.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkMemoryMapInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryMapInfo.nsize(this.address());
    }

    public VkMemoryMapInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryMapInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo sType$Default() {
        return this.sType(1000271000);
    }

    public VkMemoryMapInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryMapInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo pNext(VkMemoryMapPlacedInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryMapInfo flags(@NativeType(value="VkMemoryMapFlags") int value) {
        VkMemoryMapInfo.nflags(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryMapInfo.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo offset(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfo.noffset(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo size(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryMapInfo.nsize(this.address(), value);
        return this;
    }

    public VkMemoryMapInfo set(int sType, long pNext, int flags, long memory, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.memory(memory);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkMemoryMapInfo set(VkMemoryMapInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryMapInfo malloc() {
        return new VkMemoryMapInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryMapInfo calloc() {
        return new VkMemoryMapInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryMapInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryMapInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryMapInfo create(long address) {
        return new VkMemoryMapInfo(address, null);
    }

    public static @Nullable VkMemoryMapInfo createSafe(long address) {
        return address == 0L ? null : new VkMemoryMapInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryMapInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryMapInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryMapInfo malloc(MemoryStack stack) {
        return new VkMemoryMapInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryMapInfo calloc(MemoryStack stack) {
        return new VkMemoryMapInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkMemoryMapInfo.__struct(VkMemoryMapInfo.__member(4), VkMemoryMapInfo.__member(POINTER_SIZE), VkMemoryMapInfo.__member(4), VkMemoryMapInfo.__member(8), VkMemoryMapInfo.__member(8), VkMemoryMapInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        SIZE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryMapInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryMapInfo ELEMENT_FACTORY = VkMemoryMapInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryMapInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryMapInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryMapInfo.npNext(this.address());
        }

        @NativeType(value="VkMemoryMapFlags")
        public int flags() {
            return VkMemoryMapInfo.nflags(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryMapInfo.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkMemoryMapInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryMapInfo.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryMapInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000271000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryMapInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkMemoryMapPlacedInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkMemoryMapFlags") int value) {
            VkMemoryMapInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryMapInfo.nmemory(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryMapInfo.nsize(this.address(), value);
            return this;
        }
    }
}

